<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "point".
 *
 * @property integer $point_id
 * @property integer $road_passport_id
 * @property string $lat
 * @property string $lng
 * @property string $km
 * @property integer $num
 *
 * @property RoadPassport $roadPassport
 */
class Point extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'point';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['road_passport_id', 'num'], 'integer'],
            [['lat', 'lng', 'km'], 'number'],
            [['road_passport_id'], 'exist', 'skipOnError' => true, 'targetClass' => RoadPassport::className(), 'targetAttribute' => ['road_passport_id' => 'road_passport_id']],
            [['km'], 'number', 'min' => $this->roadPassport->begin, 'max' => $this->roadPassport->end],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'point_id' => 'Point ID',
            'road_passport_id' => 'Road Passport ID',
            'lat' => 'Lat',
            'lng' => 'Lng',
            'km' => 'Km',
            'num' => 'Num',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoadPassport()
    {
        return $this->hasOne(RoadPassport::className(), ['road_passport_id' => 'road_passport_id'])->inverseOf('points');
    }
}
