<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "department_affiliation".
 *
 * @property integer $department_affiliation_id
 * @property string $name
 *
 * @property ServiceObject[] $serviceObjects
 */
class DepartmentAffiliation extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'department_affiliation';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'department_affiliation_id' => 'Department Affiliation ID',
            'name' => 'Name',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getServiceObjects()
    {
        return $this->hasMany(ServiceObject::className(), ['department_affiliation_id' => 'department_affiliation_id']);
    }
}
