<?php
    
    namespace common\models;
    
    use Yii;
    
    /**
     * This is the model class for table "cross_section".
     * @property integer     $cross_section_id
     * @property integer     $region_id
     * @property integer     $road_id
     * @property double      $location_left
     * @property double      $location_right
     * @property string      $direction
     * @property integer     $surface_type_id
     * @property double      $length_section
     * @property double      $length_surface
     * @property double      $distance_edge
     * @property double      $width
     * @property double      $angle
     * @property integer     $tube_availability
     * @property integer     $safety_availability
     * @property integer     $year_build
     * @property integer     $year_repair
     * @property integer     $state_common_id
     * @property Region      $region
     * @property Road        $road
     * @property StateCommon $stateCommon
     * @property SurfaceType $surfaceType
     */
    class CrossSection extends \yii\db\ActiveRecord
    {
        
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'cross_section';
        }
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'region_id',
                        'road_id',
                        'surface_type_id',
                        'tube_availability',
                        'safety_availability',
                        'year_build',
                        'year_repair',
                        'state_common_id',
                    ],
                    'integer',
                ],
                [
                    [
                        'location_left',
                        'location_right',
                        'length_section',
                        'length_surface',
                        'distance_edge',
                        'width',
                        'angle',
                    ],
                    'number',
                ],
                [
                    [ 'direction' ],
                    'string',
                    'max' => 255,
                ],
                [
                    [ 'region_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Region::className(),
                    'targetAttribute' => [ 'region_id' => 'region_id' ],
                ],
                [
                    [ 'road_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Road::className(),
                    'targetAttribute' => [ 'road_id' => 'road_id' ],
                ],
                [
                    [ 'state_common_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => StateCommon::className(),
                    'targetAttribute' => [ 'state_common_id' => 'state_common_id' ],
                ],
                [
                    [ 'surface_type_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => SurfaceType::className(),
                    'targetAttribute' => [ 'surface_type_id' => 'surface_type_id' ],
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'cross_section_id'    => 'Індекс',
                'region_id'           => 'Область',
                'road_id'             => 'Дорога',
                'location_left'       => 'Місцеположення, км+ зліва',
                'location_right'      => 'Місцеположення, км+ справа',
                'direction'           => 'Напрямок з\'їзду',
                'surface_type_id'     => 'Тип покриття',
                'length_section'      => 'Фактична довжина, м з\'їзду',
                'length_surface'      => 'Фактична довжина, м покриття',
                'distance_edge'       => 'Відстань від крайки проїзної частики, м',
                'width'               => 'Ширина, м',
                'angle'               => 'Кут примикання',
                'tube_availability'   => 'Наявність облаштування, труба',
                'safety_availability' => 'Наявність облаштування, острівок безпеки',
                'year_build'          => 'Рік спорудження',
                'year_repair'         => 'Рік ремонту',
                'state_common_id'     => 'Технічний стан',
            ];
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getRegion()
        {
            return $this->hasOne(Region::className(), [ 'region_id' => 'region_id' ]);
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getRoad()
        {
            return $this->hasOne(Road::className(), [ 'road_id' => 'road_id' ]);
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getStateCommon()
        {
            return $this->hasOne(StateCommon::className(), [ 'state_common_id' => 'state_common_id' ]);
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getSurfaceType()
        {
            return $this->hasOne(SurfaceType::className(), [ 'surface_type_id' => 'surface_type_id' ]);
        }
        
        public function getRightString()
        {
            return floor($this->location_right) . '+' . ( str_pad(round(( $this->location_right - floor($this->location_right) ) * 1000), 3, '0', STR_PAD_LEFT) );
        }
        
        public function getLeftString()
        {
            return floor($this->location_left) . '+' . ( str_pad(round(( $this->location_left - floor($this->location_left) ) * 1000), 3, '0', STR_PAD_LEFT) );
        }
    }
