<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "bus_stop".
 *
 * @property integer $bus_stop_id
 * @property integer $road_id
 * @property integer $region_id
 * @property integer $settlement_id
 * @property double $location_right
 * @property double $location_left
 * @property integer $surface_type_id
 * @property integer $area_stop_availability
 * @property integer $area_land_availability
 * @property integer $pocket_availability
 * @property integer $toilet_availability
 * @property integer $year_build
 * @property integer $year_repair
 * @property integer $state_common_id
 *
 * @property Region $region
 * @property Road $road
 * @property Settlement $settlement
 * @property StateCommon $stateCommon
 * @property SurfaceType $surfaceType
 */
class BusStop extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'bus_stop';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['road_id', 'region_id', 'settlement_id', 'surface_type_id', 'area_stop_availability', 'area_land_availability', 'pocket_availability', 'toilet_availability', 'year_build', 'year_repair', 'state_common_id'], 'integer'],
            [['location_right', 'location_left'], 'number'],
            [['region_id'], 'exist', 'skipOnError' => true, 'targetClass' => Region::className(), 'targetAttribute' => ['region_id' => 'region_id']],
            [['road_id'], 'exist', 'skipOnError' => true, 'targetClass' => Road::className(), 'targetAttribute' => ['road_id' => 'road_id']],
            [['settlement_id'], 'exist', 'skipOnError' => true, 'targetClass' => Settlement::className(), 'targetAttribute' => ['settlement_id' => 'settlement_id']],
            [['state_common_id'], 'exist', 'skipOnError' => true, 'targetClass' => StateCommon::className(), 'targetAttribute' => ['state_common_id' => 'state_common_id']],
            [['surface_type_id'], 'exist', 'skipOnError' => true, 'targetClass' => SurfaceType::className(), 'targetAttribute' => ['surface_type_id' => 'surface_type_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'bus_stop_id' => 'Індекс',
            'road_id' => 'Дорога',
            'region_id' => 'Область',
            'settlement_id' => 'Назва населеного пункту',
            'location_right' => 'Місцезнаходження, км+ справа',
            'location_left' => 'Місцезнаходження, км+ зліва',
            'surface_type_id' => 'Тип покриття',
            'area_stop_availability' => 'Наявність елементів зупин. майдан',
            'area_land_availability' => 'Наявність елементів посад. майдан',
            'pocket_availability' => 'Наявність елементів заїзна кишеня',
            'toilet_availability' => 'Наявність елементів туалет',
            'year_build' => 'Рік будівництва',
            'year_repair' => 'Рік ремонту',
            'state_common_id' => 'Технічний стан',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRegion()
    {
        return $this->hasOne(Region::className(), ['region_id' => 'region_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoad()
    {
        return $this->hasOne(Road::className(), ['road_id' => 'road_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSettlement()
    {
        return $this->hasOne(Settlement::className(), ['settlement_id' => 'settlement_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getStateCommon()
    {
        return $this->hasOne(StateCommon::className(), ['state_common_id' => 'state_common_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSurfaceType()
    {
        return $this->hasOne(SurfaceType::className(), ['surface_type_id' => 'surface_type_id']);
    }

    public function getRightString()
    {
        return floor($this->location_right) . '+' . ( str_pad(round(( $this->location_right - floor($this->location_right) ) * 1000), 3, '0', STR_PAD_LEFT) );
    }

    public function getLeftString()
    {
        return floor($this->location_left) . '+' . ( str_pad(round(( $this->location_left - floor($this->location_left) ) * 1000), 3, '0', STR_PAD_LEFT) );
    }
}
