$(document).ready(function(){
    footer();
    cabinet();
    formsHome();
    initDatePicker();

    function footer(){
        footerBottom();
        resizeFooterBottom();

        function footerBottom(){
            var heightHeader = $('.section-box-header').height()
            var heightFooter = $('.section-box-footer').height()
            var windowHeight = $(window).height()
            $('.section-box-content').css({minHeight:windowHeight-heightHeader-heightFooter})
        }

        function resizeFooterBottom(){
            $(window).resize(function(){
                footerBottom();
            })
        }
    }
    
    function cabinet() {
        sidebar();
        forms();
        tabsContentOiv();

        function sidebar() {
            $('.second-list a').click(function(e) {
                e.stopPropagation();
            });
            $('.list-cab li').click(function (e) {
                if($(this).hasClass('disabled')) {
                    e.preventDefault();
                    return false;
                }
                var dropDownList = $(this).find('ul').length;
                if(dropDownList){
                    e.preventDefault();
                    $('.list-cab li').removeClass('active-li');
                    $(this).addClass('active-li');
                }
            });

        }
        function forms() {
            if($('.phone-input input').length){
                $('.phone-input input').mask('+38 (000) 000 00 00');
            }
        }
        function tabsContentOiv() {
            $('.oiv-list li').click(function (e) {
                e.preventDefault()
                if($(this).hasClass('active-list-oiv')){

                } else {
                    $('.table-wrapp-2').after('<div id="preload-cab"><div></div></div>')
                    $('.oiv-list li').removeClass('active-list-oiv')
                    $(this).addClass('active-list-oiv')

                    var thisNum = $(this).index()
                    var cabContent = $('.hidden-tables-oiv')


                    setTimeout(function () {
                        cabContent.removeClass('active-tab-oiv')
                        $(cabContent[thisNum]).addClass('active-tab-oiv')
                        $('#preload-cab').remove()
                    },800)
                }
            })
        }
    }

    function formsHome() {
        $('.btn_login, .btn_login_2').click(function (e) {
            if($(this).hasClass('login_user')) {
                return true;
            }
            e.preventDefault()
            var pos = ($(window).scrollTop())+20
            $('#overlay').fadeIn(400,
                function(){
                    $('#login_form')
                        .css('display', 'block')
                        .animate({opacity: 1, top: pos}, 200);
                });
        })

        $('#modal_close, #overlay').click( function(){
            $('.forms_').animate({opacity: 0, top: '0'}, 200,function(){
                $(this).css('display', 'none');
                $('#overlay').fadeOut(400);
            });
        });

        $('.btn_register').click( function(e){
            e.preventDefault()
            var pos = ($(window).scrollTop())+20
            $('#login_form').animate({opacity: 0, top: '-50px'}, 200,function(){
                $('#register_form')
                    .css('display', 'block')
                    .animate({opacity: 1, top: pos}, 200);
            });
        });



        $('#login_form form button').click(function (e) {
            if($('#input-1').val().length<1){
                e.preventDefault()
                $('#input-1').addClass('errors')
            } else {
                $('#input-1').removeClass('errors')
            }
            if($('#input-2').val().length<1){
                e.preventDefault()
                $('#input-2').addClass('errors')
            } else {
                $('#input-2').removeClass('errors')
            }
        })

        $('#register_form form button').click(function (e) {
            if($('#input-3').val().length<1){
                e.preventDefault()
                $('#input-3').addClass('errors')
            } else {
                $('#input-3').removeClass('errors')
            }
            if($('#input-4').val().length<1){
                e.preventDefault()
                $('#input-4').addClass('errors')
            } else {
                $('#input-4').removeClass('errors')
            }
            if($('#input-5').val().length<1){
                e.preventDefault()
                $('#input-5').addClass('errors')
            } else {
                $('#input-5').removeClass('errors')
            }
        })
    }

    $(document).on('beforeSubmit', '#personal-form', function(e) {
        postForm(this);
        return false;
    });

    $(document).on('beforeSubmit', '#users-add-form', function(e) {
        postForm(this, true, 'users-table', true, true);
        return false;
    });

    $(document).on('beforeSubmit', '#passport-form', function(e) {
        postForm(this);
        return false;
    });

    $(document).on('beforeSubmit', '#property-form', function(e) {
        postForm(this);
        return false;
    });

    $(document).on('pjax:complete', function() {
        initDatePicker();
    });

    function initDatePicker() {
        $('._datepicer, ._datepicker')
            .datepicker(
                {
                    changeMonth: true,
                    changeYear: true,
                    dateFormat: 'dd.mm.yy',
                    closeText: 'Закрыть',
                    prevText: 'Пред',
                    nextText: 'След',
                    monthNames: [
                        'Январь',
                        'Февраль',
                        'Март',
                        'Апрель',
                        'Май',
                        'Июнь',
                        'Июль',
                        'Август',
                        'Сентябрь',
                        'Октябрь',
                        'Ноябрь',
                        'Декабрь'
                    ],
                    monthNamesShort: [
                        'Январь',
                        'Февраль',
                        'Март',
                        'Апрель',
                        'Май',
                        'Июнь',
                        'Июль',
                        'Август',
                        'Сентябрь',
                        'Октябрь',
                        'Ноябрь',
                        'Декабрь'
                    ],
                    dayNames: [
                        'воскресенье',
                        'понедельник',
                        'вторник',
                        'среда',
                        'четверг',
                        'пятница',
                        'суббота'
                    ],
                    dayNamesShort: [
                        'вск',
                        'пнд',
                        'втр',
                        'срд',
                        'чтв',
                        'птн',
                        'сбт'
                    ],
                    dayNamesMin: [
                        'Вс',
                        'Пн',
                        'Вт',
                        'Ср',
                        'Чт',
                        'Пт',
                        'Сб'
                    ],
                    firstDay: 1
                }
            );
    }

    function postForm(context, reload_pjax, pjax, close, reset) {
        $.post($(context).attr('action'), $(context).serialize(), function(data) {
            var type;
            if(data.error) {
                type = 'danger';
            } else {
                type = 'success';
                if(close) {
                    tryClose(context);
                }
                if(reset) {
                    context.reset();
                }
            }
            showStatus(data.message, type);
            if(reload_pjax) {
                if(pjax) {
                    reload(pjax);
                } else {
                    reload($(context).parents('.pjax_container').attr('id'));
                }
            }
        }.bind(this));
    }

    function tryClose(context) {
        $(context).parents('.modal').modal('hide');
    }

    function showStatus(txt, type) {
        $.notify({
            message: txt
        }, {
            type: type
        });
    }

    function reload(id) {
        $('#'+id).prepend('<div class="preloader"></div>');
        $.pjax.reload('#'+id);
    }

    $(document).on('beforeSubmit', '#add-int-prop-form', function() {
        $.post($(this).attr('action'), $(this).serialize(), function(data) {
            var type;
            if(data.error) {
                type = 'danger';
            } else {
                type = 'success';
            }
            $('#add-composition-modal').modal('hide');
            showStatus(data.message, type);
            $.pjax.reload('#int-prop-greed');
            document.getElementById('add-int-prop-form').reset();
        });

        return false;
    });

    $(document).on('beforeSubmit', '#add-role-form', function() {
        $.post($(this).attr('action'), $(this).serialize(), function(data) {
            var type;
            if(data.error) {
                type = 'danger';
            } else {
                type = 'success';
            }
            $('#add-role-modal').modal('hide');
            showStatus(data.message, type);
            $.pjax.reload('#roles-table');
            document.getElementById('add-role-form').reset();
        });

        return false;
    });

    $(document).on('submit', '#update-role-form', function() {
        $.post($(this).attr('action'), $(this).serialize(), function(data) {
            var type;
            if(data.error) {
                type = 'danger';
            } else {
                type = 'success';
            }
            $('#update-role-modal').modal('hide');
            showStatus(data.message, type);
            $.pjax.reload('#roles-table');
            $('#update-role-modal').html('');
        });

        return false;
    });

    $(document).on('click', '.delete-role', function(e) {
        e.preventDefault();
        confirm('Удалить роль?');
        $.post('delete-role', {
            id:$(this).attr('data-id')
        }, function(data) {
            var type;
            if(data.error) {
                type = 'danger';
            } else {
                type = 'success';
            }
            showStatus(data.message, type);
            $.pjax.reload('#roles-table');
        });
    });

    $(document).on('click', '.update-role', function(e) {
        e.preventDefault();
        $.post('get-role-form', {
            id:$(this).attr('data-id')
        }, function(data) {
            $('#update-role-modal').html(data.answer);
            $('#update-role-modal').modal('show');
        });
    });

    $(document).on('click', '.remove-int-prop', function(e) {
        e.preventDefault();
        confirm('Удалить элемент?');
        $.post('delete-int-property', {
            id:$(this).attr('data-id')
        }, function(data) {
            var type;
            if(data.error) {
                type = 'danger';
            } else {
                type = 'success';
            }
            showStatus(data.message, type);
            $.pjax.reload('#int-property-table');
        });
    });
});




