<?php
    
    /**
     * @var View $this
     * @var LoginForm $loginForm
     */
    
    use common\models\LoginForm;
    use yii\helpers\Html;
    use yii\helpers\Url;
    use yii\web\View;
    use yii\widgets\ActiveForm;
    
    $this->title = 'My Yii Application';
?>

<div class="section-box-header">
    <div class="container">
        <div class="row">
            <div class="col-sm-12">
                <a class="logo-home" href="#"><img src="/images/logo.png" width="155" height="66" alt=""></a>
                <ul class="main_menu">
                    <li><a href="#">creators</a></li>
                    <li><a href="#">музика користувача</a></li>
                    <li><a href="#">новини</a></li>
                    <li><a href="#">відео</a></li>
                    <li><a href="#">інтелектуальні права</a></li>
                </ul>
                <div class="login-wrapp">
                    <?php
                        if(!\Yii::$app->user->isGuest) {
                            echo Html::a('Вийти',
                                         [
                                             'site/logout'
                                         ],
                                         [
                                             'data-method' => 'post',
                                             'class' => 'btn-logout',
                                         ]);
                        }
                    ?>
                    <?php
                    if(\Yii::$app->user->isGuest) {
                        echo Html::a('вхід', '#', [
                            'class' => 'btn_login',
                        ]);
                    } else {
                        echo Html::a(\Yii::$app->user->identity->username, [
                            'cabinet/index',
                        ], [
                            'class' => 'btn_login login_user',
                        ]);
                    }
                    ?>
                    
                </div>
            </div>
        </div>
    </div>
</div>
<div class="section-box-content">
    <div class="section-box-1"></div>
    <div class="section-box-2" style="margin-top: 60px">
        <div class="container">
            <div class="row">
                <div class="col-sm-12"><img src="/images/img/img-2.jpg" style="width: 100%;" alt=""></div>
            </div>
        </div>
    </div>
    <div class="section-box-3" style="margin-top: 60px;">
        <div class="container">
            <div class="row">
                <div class="col-xs-6 col-sm-6"><img style="width: 100%; margin-top: 40px;" src="/images/img/img-6.png" alt=""></div>
                <div class="col-xs-6 col-sm-6">
                    <ul class="btns-box3">
                        <li><a class="btn_login_2" href="#"><img src="/images/img/ico/ico-1.png" alt=""></a></li>
                        <li><a href="#"><img src="/images/img/ico/ico-2.png" alt=""></a></li>
                        <li><a href="#"><img src="/images/img/ico/ico-3.png" alt=""></a></li>
                    </ul>
                    <span class="box-3-txt">Отримати безкоштовну консультацію спеціаліста</span>
                </div>
            </div>
        </div>
    </div>
    
    <div class="section-box-4">
        <div class="container">
            <div class="row">
                <div class="col-sm-12"><img src="/images/img/img-5.jpg" style="width: 100%;" alt=""></div>
            </div>
        </div>
    </div>
    <div class="section-box-5"></div>
    
    <div class="section-box-last">
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-12"><span>Розробляючи сервіс E-creators, ми прагнули створити найпростішу, швидку, зручну, прозору і інформативну платформу для вигідного співробітництва авторів музики з її споживачами по всьому світу.</span></div>
            </div>
        </div>
    </div>
</div>
<div class="section-box-footer">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                <div class="row">
                    <div class="hidden visible_all col-xs-12 col-sm-6">
                        <div class="copyright">© Extremstyle, 2015. Все права защищены.</div>
                    </div>
                    <div class="col-xs-12 col-sm-6">
                        <div class="artweb-wr">
                            <a target="_blank" href="http://artweb.ua/">Создание сайтов</a>
                            <div class="artweb-img">
                                <a target="_blank" href="http://artweb.ua/"><img src="/images/artweb-logo.png"></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div id="overlay"></div>
<div id="login_form" class="forms_">
    <span id="modal_close"></span>
    <?php
        $form = ActiveForm::begin([
            'id' => 'login-form',
                                  ]);
        ?>
    <div class="style bg_form">
        <div class="" style="width: 420px; margin: 0 auto">
            <div class="title_reg-form">Будь ласка,<br /> введіть Вашу інформацію нижче</div>
            <div class="style" style="margin-top: 13px;">
                <?php
                    echo $form->field($loginForm, 'username', [
                        'options' => [
                            'style' => 'padding: 0 51px',
                            'class' => 'style',
                        ]
                    ])->textInput();
                    echo $form->field($loginForm, 'password', [
                        'options' => [
                            'style' => 'padding: 0 51px',
                            'class' => 'style',
                        ]
                    ])->passwordInput();
                ?>
            </div>
            
            <div class="style" style="text-align: center; margin-top: 17px;">
                <a class="btn-recovery" href="#">Забули пароль?</a>
            </div>
            
            <div class="style btn-form-login" style="margin-top: 29px;">
                <button type="submit">вхід</button>
            </div>
        
        </div>
    
    </div>
    <?php
        $form::end();
    ?>
    <div class="style" style="background: #fff">
        <div class="style" style="padding: 0 98px;">
            <div class="title-begin">Почати</div>
            <div class="style">
                <div class="blocks_ right-owner">
                    <div class="title-blocks_">правовласникам</div>
                    <div class="help-blocks_">Я беру участь у створенні аудіомузичних творів</div>
                    <a href="#" class="btn-right-owner btn_blocks_">почати з e-creators</a>
                </div>
                <div class="blocks_ users_">
                    <div class="title-blocks_">Користувачам</div>
                    <div class="help-blocks_">Я використовую аудіомузичні твори у своєму бізнесі</div>
                    <a href="#" class="btn-users_ btn_blocks_">Отримати ліцензію</a>
                </div>
            </div>
            <div class="style new-user">Новий користувач? <a class="btn_register" href="#">Створити обліковий запис</a></div>
        </div>
    </div>
</div>

<div id="register_form" class="forms_">
    <span id="modal_close"></span>
    <form action="<?php echo Url::to(['/cabinet/index']); ?>">
        <div class="style bg_form">
            <div class="" style="width: 420px; margin: 0 auto">
                <div class="title_reg-form">Реєстрація правовласника</div>
                <div class="style" style="margin-top: 13px;">
                    <div class="style" style="padding: 0 51px">
                        <label for="input-3">Логін</label>
                        <input id="input-3" type="text">
                    </div>
                    <div class="style" style="padding: 0 51px">
                        <label for="input-4">Пароль</label>
                        <input id="input-4" type="password">
                    </div>
                    <div class="style" style="padding: 0 51px">
                        <label for="input-5">e-mail</label>
                        <input id="input-5" type="text">
                    </div>
                </div>
                
                <div class="style btn-form-login" style="margin-top: 29px;">
                    <button type="submit">зареєструватися</button>
                </div>
            
            </div>
        
        </div>
    </form>
    <div class="style" style="background: #fff">
        <div class="register-soc" style="text-align: center; margin-top: 40px;margin-bottom: 45px;"><img src="/images/img/forms/img-1.jpg" width="476" height="117" alt=""></div>
    </div>
</div>
