<?php
    use frontend\assets\CabinetAsset;
    use yii\helpers\Html;
    use yii\widgets\Menu;
    
    /**
     * @var \yii\web\View $this
     * @var string        $content
     */
    
    CabinetAsset::register($this);
    $this->beginContent('@frontend/views/layouts/main.php');
?>
<div class="section-box-header">
    <?php
        echo Html::a(
            Html::img(
                '/images/cabinet/logo.png',
                [
                    'width'  => 129,
                    'height' => 52,
                ]
            ),
            [ 'cabinet/index' ],
            [
                'class' => 'logo-cab',
            ]
        )
    ?>
  <div class="cabinet_header-title"><span>Система обліку використання інтелектуальної власності</span></div>

  <div class="checkbox-header-cabinet">
    <form action="">
      <div class="custom-buttons-slide">
        <a href="#">Автор</a>
        <input type="checkbox" class="custom-check-slide" name="q2">
        <a href="#">Видавець</a>
      </div>
    </form>
      <?php
          $js = <<<EOT
var widthCheckSlider = ($('.checkbox-header-cabinet')
                                .width()) / 2
                        $('.checkbox-header-cabinet')
                            .css({marginLeft: -widthCheckSlider})
                        $(".custom-check-slide")
                            .iosCheckbox();
                        $('.custom-buttons-slide a')
                            .click(
                                function(e) {
                                    e.preventDefault();
                                    var label = $(this)
                                        .siblings('.check-slide');
                                    var closerInput = $(this)
                                        .siblings('input[type="checkbox"]');
                                    if (label.hasClass('checked')) {
                                        label.removeClass('checked');
                                        closerInput.prop('checked', false);
                                    } else {
                                        label.addClass('checked');
                                        closerInput.prop('checked', true);
                                    }
                                }
                            );
EOT;
          $this->registerJs($js);
      ?>
  </div>

  <div class="head-wr-login">
    <a href="#" class="btn_mails"><span>23</span></a>

    <div class="name-wrapp-login">
      <span class="name_" style="background: url('/images/cabinet/ico/ico-5.png')0 50% no-repeat"><?php echo \Yii::$app->user->identity->name?></span>
      <div id="hidden_list_head" class="_off">
        <ul>
          <li><span class="s_">Киев</span></li>
        </ul>
      </div>
    </div>
  </div>
</div>
<div class="section-box-content">
  <div class="sidebar-cab">
      <?php
          echo Menu::widget(
              [
                  'options'        => [
                      'class' => 'list-cab',
                  ],
                  'encodeLabels'   => false,
                  'activeCssClass' => 'active-li',
                  'items'          => [
                      [
                          'label' => Html::tag(
                                  'span',
                                  '',
                                  [
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-1.png') 50% 50% no-repeat",
                                  ]
                              ) . Html::tag(
                                  'span',
                                  '',
                                  [
                                      'class' => 'act_bg',
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-1-act.png') 50% 50% no-repeat",
                                  ]
                              ) . 'Особисті дані',
                          'url'   => [ 'cabinet/index' ],
                      ],
                      [
                          'label'   => Html::tag(
                                  'span',
                                  '',
                                  [
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-2.png') 50% 50% no-repeat",
                                  ]
                              ) . Html::tag(
                                  'span',
                                  '',
                                  [
                                      'class' => 'act_bg',
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-2-act.png') 50% 50% no-repeat",
                                  ]
                              ) . 'Мої соавтори',
                          'url'     => [ 'cabinet/authors' ],
                          'options' => [
                              'class' => 'disabled',
                          ],
                      ],
                      [
                          'label'   => Html::tag(
                                  'span',
                                  '',
                                  [
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-3.png') 50% 50% no-repeat",
                                  ]
                              ) . Html::tag(
                                  'span',
                                  '',
                                  [
                                      'class' => 'act_bg',
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-3-act.png') 50% 50% no-repeat",
                                  ]
                              ) . 'Рахунки',
                          'url'     => [ 'cabinet/bills' ],
                          'options' => [
                              'class' => 'disabled',
                          ],
                      ],
                      [
                          'label'   => Html::tag(
                                  'span',
                                  '',
                                  [
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-4.png') 50% 50% no-repeat",
                                  ]
                              ) . Html::tag(
                                  'span',
                                  '',
                                  [
                                      'class' => 'act_bg',
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-4-act.png') 50% 50% no-repeat",
                                  ]
                              ) . 'Адреси',
                          'url'     => [ 'cabinet/addresses' ],
                          'options' => [
                              'class' => 'disabled',
                          ],
                      ],
                      [
                          'label'   => Html::tag(
                                  'span',
                                  '',
                                  [
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-5.png') 50% 50% no-repeat",
                                  ]
                              ) . Html::tag(
                                  'span',
                                  '',
                                  [
                                      'class' => 'act_bg',
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-5-act.png') 50% 50% no-repeat",
                                  ]
                              ) . 'Додадково',
                          'url'     => [ 'cabinet/additional' ],
                          'options' => [
                              'class' => 'disabled',
                          ],
                      ],
                      [
                          'label' => Html::tag(
                                  'span',
                                  '',
                                  [
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-6.png') 50% 50% no-repeat",
                                  ]
                              ) . Html::tag(
                                  'span',
                                  '',
                                  [
                                      'class' => 'act_bg',
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-6-act.png') 50% 50% no-repeat",
                                  ]
                              ) . 'Каталог ОІВ',
                          'url'   => [ 'cabinet/properties' ],
                          'items' => [
                              [
                                  'label'   => Html::tag(
                                          'span',
                                          '',
                                          [
                                              'style' => "background: url('/images/cabinet/icon-menu/ico-6-1.png') 50% 50% no-repeat",
                                          ]
                                      ) . Html::tag(
                                          'span',
                                          '',
                                          [
                                              'class' => 'act_bg',
                                              'style' => "background: url('/images/cabinet/icon-menu/ico-6-1-act.png') 50% 50% no-repeat",
                                          ]
                                      ) . 'продаж ОІВ',
                                  'url'     => [ 'cabinet/sales' ],
                                  'options' => [
                                      'class' => 'second-list',
                                  ],
                              ],
                              [
                                  'label'   => Html::tag(
                                          'span',
                                          '',
                                          [
                                              'style' => "background: url('/images/cabinet/icon-menu/ico-6-2.png') 50% 50% no-repeat",
                                          ]
                                      ) . Html::tag(
                                          'span',
                                          '',
                                          [
                                              'class' => 'act_bg',
                                              'style' => "background: url('/images/cabinet/icon-menu/ico-6-2-act.png') 50% 50% no-repeat",
                                          ]
                                      ) . 'список ОІВ',
                                  'url'     => [ 'cabinet/list' ],
                                  'options' => [
                                      'class' => 'second-list',
                                  ],
                              ],
                          ],
                      ],
                      [
                          'label' => Html::tag(
                                  'span',
                                  '',
                                  [
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-7.png') 50% 50% no-repeat",
                                  ]
                              ) . Html::tag(
                                  'span',
                                  '',
                                  [
                                      'class' => 'act_bg',
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-7-act.png') 50% 50% no-repeat",
                                  ]
                              ) . 'Мої надходження',
                          'url'   => [ 'cabinet/arrivals' ],
                      ],
                      [
                          'label' => Html::tag(
                                  'span',
                                  '',
                                  [
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-8.png') 50% 50% no-repeat",
                                  ]
                              ) . Html::tag(
                                  'span',
                                  '',
                                  [
                                      'class' => 'act_bg',
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-8-act.png') 50% 50% no-repeat",
                                  ]
                              ) . 'Звіти',
                          'url'   => [ 'cabinet/reports' ],
                          'items' => [
                              [
                                  'label'   => Html::tag(
                                          'span',
                                          '',
                                          [
                                              'style' => "background: url('/images/cabinet/icon-menu/ico-8-2.png') 50% 50% no-repeat",
                                          ]
                                      ) . Html::tag(
                                          'span',
                                          '',
                                          [
                                              'class' => 'act_bg',
                                              'style' => "background: url('/images/cabinet/icon-menu/ico-8-2-act.png') 50% 50% no-repeat",
                                          ]
                                      ) . 'звіт у розрізі користувачів',
                                  'url'     => [ 'cabinet/users' ],
                                  'options' => [
                                      'class' => 'second-list',
                                  ],
                              ],
                              [
                                  'label'   => Html::tag(
                                          'span',
                                          '',
                                          [
                                              'style' => "background: url('/images/cabinet/icon-menu/ico-8-1.png') 50% 50% no-repeat",
                                          ]
                                      ) . Html::tag(
                                          'span',
                                          '',
                                          [
                                              'class' => 'act_bg',
                                              'style' => "background: url('/images/cabinet/icon-menu/ico-8-1-act.png') 50% 50% no-repeat",
                                          ]
                                      ) . 'звіт з кількістью сповіщень',
                                  'url'     => [ 'cabinet/notifications' ],
                                  'options' => [
                                      'class' => 'second-list',
                                  ],
                              ],
                          ],
                      ],
                      [
                          'label'   => Html::tag(
                                  'span',
                                  '',
                                  [
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-9.png') 50% 50% no-repeat",
                                  ]
                              ) . Html::tag(
                                  'span',
                                  '',
                                  [
                                      'class' => 'act_bg',
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-9-act.png') 50% 50% no-repeat",
                                  ]
                              ) . 'допомога',
                          'url'     => [ 'cabinet/help' ],
                          'options' => [
                              'class' => 'disabled',
                          ],
                      ],
                      [
                          'label'   => Html::tag(
                                  'span',
                                  '',
                                  [
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-1.png') 50% 50% no-repeat",
                                  ]
                              ) . Html::tag(
                                  'span',
                                  '',
                                  [
                                      'class' => 'act_bg',
                                      'style' => "background: url('/images/cabinet/icon-menu/ico-1-act.png') 50% 50% no-repeat",
                                  ]
                              ) . 'Вийти',
                          'url'     => [ 'site/logout' ],
                          'template' => '<a href="{url}" data-method="post">{label}</a>'
                      ],
                  ],
              ]
          );
      ?>
  </div>

  <div class="content-forms">
      <?php
          echo $content;
      ?>
  </div>
</div>
<div class="section-box-footer">
  <a class="btn_create_footer" href="#">Створити</a>
  <a class="btn_remove_footer" href="#">Видалити</a>
</div>
<?php
    $this->endContent();
?>
