<?php
    use common\models\User;
    use frontend\models\IntellectualProperty;
    use frontend\models\Report;
    use yii\helpers\Html;
    use yii\helpers\VarDumper;
    use yii\web\View;
    use yii\widgets\ActiveForm;
    use yii\widgets\Pjax;
    
    /**
     * @var View     $this
     * @var Report[] $reports
     * @var User $user
     */
    
    $user = \Yii::$app->user->identity;
?>
<div class="style cab_content_list">
    <div class="cab_content_list-dropdown">
        <div class="style table-forms tables-1">
            <div class="title_forms">Звіт про загальну суму винагороди (у розрізі користувачів)</div>
            <div class="btn-submit-blue">
                <?php if ($user->isAdmin()) echo Html::button(
                    'Добавить',
                    [
                        'type'        => 'button',
                        'class'       => 'add-button',
                        'data-toggle' => 'modal',
                        'data-target' => '#add-user-report',
                    ]
                ) ?>
            </div>
            <?php
                Pjax::begin(
                    [
                        'id'      => 'users-table',
                        'options' => [
                            'class' => 'style table-forms-wrapp',
                        ],
                    ]
                );
            ?>
            <table class="table-1" cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td>№<br/>п/п</td>
                    <td>Користувач</td>
                    <td>Твір</td>
                    <td>Кількість сповіщень</td>
                    <td>Перерахована сума</td>
                    <td>Комісія агенства</td>
                    <td>Нараховано автору</td>
                    <td>Податки</td>
                    <td>Сума до виплати</td>
                </tr>
                <?php
                  $total = 0;
                    foreach ($reports as $index => $report) {
                      if ($user->isAdmin()) {
                        $sum = $report->sum;
                      } else {
                        $sum = $report->sum * $report->intellectualProperty->creativeRole->part / 100;
                      }
                      $total += $sum*0.8*0.805;
                        ?>
                        <tr>
                            <?php
                                echo Html::tag('td', ++$index);
                                echo Html::tag('td', $report->user);
                                echo Html::tag('td', $report->intellectualProperty->title);
                                echo Html::tag('td', $report->count);
                                echo Html::tag('td', $sum);
                                echo Html::tag('td', $sum*0.2);
                                echo Html::tag('td', $sum*0.8);
                                echo Html::tag('td', $sum*0.8*0.195);
                                echo Html::tag('td', $sum*0.8*0.805);
                            ?>
                        </tr>
                        <?php
                    }
                ?>
              <tr>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td>Сумма: </td>
                <td><?=$total?></td>
              </tr>
            </table>
            <?php
                Pjax::end();
            ?>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="add-user-report" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Додати звіт</h4>
            </div>
            <?php
                $form = ActiveForm::begin(
                    [
                        'action' => [ '/cabinet/users-add' ],
                        'id'     => 'users-add-form',
                    ]
                );
                $report = new Report();
            ?>
            <div class="modal-body forms-cabinet forms-2">
                <?php
                    echo $form->field($report, 'user')
                              ->textInput();
//                    echo $form->field($report, 'artist');
                    echo $form->field($report, 'intellectual_property_id')
                              ->dropDownList(
                                  IntellectualProperty::find()
                                                      ->asArray()
                                                      ->select(
                                                          [
                                                              'title',
                                                              'id',
                                                          ]
                                                      )
                                                      ->indexBy('id')
                                                      ->column()
                              );
                    echo $form->field($report, 'count')
                              ->textInput();
                    echo $form->field($report, 'sum')
                              ->textInput();
                ?>
            </div>
            <div class="clearfix"></div>
            <div class="modal-footer btn-submit-blue">
                <?php
                    echo Html::submitButton(
                        'OK'
                    );
                ?>
            </div>
            <?php
                $form::end();
            ?>
        </div>
    </div>
</div>
