<?php
    use common\models\User;
    use frontend\models\CreativeRole;
    use frontend\models\IntellectualProperty;
    use yii\helpers\ArrayHelper;
    use yii\helpers\Html;
    use yii\web\View;
    use yii\widgets\ActiveForm;
    use yii\widgets\Pjax;
    
    /**
     * @var View                 $this
     * @var IntellectualProperty $property
     * @var CreativeRole[]       $table
     */
    
    /**
     * @var User $user
     */
    $user = \Yii::$app->user->identity;
?>
    <div class="style cab_content_list">
        <div class="cab_content_list-dropdown">
            <?php
                Pjax::begin(
                    [
                        'options' => [
                            'class' => 'pjax_container forms-cabinet forms-3',
                        ],
                    ]
                );
            ?>
            <div class="title_forms">Продаж ОІВ</div>
            <?php
                if ($user->isAdmin() || $property->user_id == $user->id) {
                    $form = ActiveForm::begin(
                        [
                            'id'     => 'property-form',
                            'action' => \Yii::$app->request->url,
                        ]
                    );
                }
            ?>
            <?php
                if ($user->isAdmin() || $property->user_id == $user->id) {
                    ?>
                    <div class="style background_form">
                        <?php
                            echo $form->field(
                                $property,
                                'title',
                                [
                                    'options' => [
                                        'class' => 'input-wrapp-757',
                                        'style' => 'margin-right: 40px;',
                                    ],
                                ]
                            )
                                      ->textarea(
                                          [
                                              'cols' => 30,
                                              'rows' => 10,
                                          ]
                                      );
                            echo $form->field(
                                $property,
                                'creation_date',
                                [
                                    'options' => [
                                        'class' => 'input-wrapp-130',
                                    ],
                                ]
                            )
                                      ->textInput(
                                          [
                                              'class' => '_datepicer',
                                          ]
                                      );
                        ?>
                        <div class="style">
                            <?php
                                echo $form->field(
                                    $property,
                                    'code',
                                    [
                                        'options' => [
                                            'class' => 'input-wrapp-320',
                                        ],
                                    ]
                                )
                                          ->textInput();
                            ?>
                        </div>
                        <div class="style">
                            <?php
                                echo $form->field(
                                    $property,
                                    'genre',
                                    [
                                        'options' => [
                                            'class' => 'input-wrapp-320',
                                        ],
                                    ]
                                )
                                          ->textInput();
                            ?>
                        </div>
                        <div class="style">
                            <?php
                                echo $form->field(
                                    $property,
                                    'registration_date',
                                    [
                                        'options' => [
                                            'class' => 'input-wrapp-320',
                                        ],
                                    ]
                                )
                                          ->textInput(
                                              [
                                                  'class' => '_datepicer',
                                              ]
                                          );
                            ?>
                        </div>
                        <div class="style">
                            <?php
                                echo $form->field(
                                    $property,
                                    'contract',
                                    [
                                        'options' => [
                                            'class' => 'input-wrapp-320',
                                            'style' => 'margin-right: 40px;',
                                        ],
                                    ]
                                )
                                          ->textInput();
                                echo $form->field(
                                    $property,
                                    'type',
                                    [
                                        'options' => [
                                            'class' => 'input-wrapp-320',
                                        ],
                                    ]
                                )
                                          ->textInput();
                            ?>
                        </div>
                    
                    </div>
                    <?php
                }
            ?>
            <?php
                if (!$property->isNewRecord) {
                    if ($user->isAdmin() || $property->user_id == $user->id) {
                        ?>
                        <div class="btn-submit-blue">
                            <?php echo Html::button(
                                'Додати',
                                [
                                    'type'        => 'button',
                                    'class'       => 'add-role-button',
                                    'data-toggle' => 'modal',
                                    'data-target' => '#add-role-modal',
                                ]
                            ) ?>
                        </div>
                        <?php
                    }
                    ?>
                    
                    <div class="style wrapp-tabs-table">
                        <div class="style table-wrapp-2">
                            <div class="hidden-tables-oiv active-tab-oiv">
                                <?php
                                    Pjax::begin(
                                        [
                                            'id' => 'roles-table',
                                        ]
                                    );
                                ?>
                                <table class="table-1 table-2" cellpadding="0" cellspacing="0" border="0">
                                    <tr>
                                        <td>Творча роль</td>
                                        <td>ПІБ</td>
                                        <td>Доля %</td>
                                        <td>Код</td>
                                        <td>IPI</td>
                                        <td>Товариство</td>
                                        <td class="refactor-td"></td>
                                    </tr>
                                    <?php
                                        foreach ($table as $row) {
                                            ?>
                                            <tr>
                                                <td><?= $row->title ?></td>
                                                <td><?= $row->user->userData->name . ' ' . $row->user->userData->surname ?></td>
                                                <td><?= $row->part ?></td>
                                                <td><?= $row->code ?></td>
                                                <td><?= $row->iri ?></td>
                                                <td><?= $row->society ?></td>
                                                <td>
                                                    <?php
                                                        if ($user->isAdmin() || $property->user_id == $user->id) {
                                                            ?>
                                                            <a href="#" class="edit-table update-role" data-id="<?= $row->id ?>"></a>
                                                            <a href="#" class="remove-table delete-role" data-id="<?= $row->id ?>"></a>
                                                            <?php
                                                        }
                                                    ?>
                                                </td>
                                            </tr>
                                            <?php
                                        }
                                    ?>
                                </table>
                                <?php
                                    Pjax::end();
                                ?>
                            </div>
                        </div>
                    </div>
                    <?php
                }
            ?>
            <?php
                if ($user->isAdmin() || $property->user_id == $user->id) {
                    ?>
                    <div class="input-wrapp btn-submit-blue">
                        <?php
                            echo Html::submitButton('зберегти');
                        ?>
                    </div>
                    <?php
                    $form::end();
                }
            ?>
            <?php
                Pjax::end();
            ?>
        </div>
    </div>
<?php
    if (!$property->isNewRecord && ( $user->isAdmin() || $property->user_id == $user->id )) {
        ?>
        <!-- Modal -->
        <div class="modal fade" id="add-role-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="myModalLabel">Додати роль</h4>
                    </div>
                    <?php
                        $form = ActiveForm::begin(
                            [
                                'action' => 'add-role',
                                'id'     => 'add-role-form',
                            ]
                        );
                        $addRole = new CreativeRole();
                    ?>
                    <div class="modal-body forms-cabinet forms-2">
                        
                        
                        <?php
                            echo $form->field($addRole, 'title');
                        ?>
                        
                        <?php
                            echo $form->field($addRole, 'user_id')
                                      ->dropDownList(
                                          ArrayHelper::getColumn(
                                              User::find()
                                                  ->joinWith('userData')
                                                  ->indexBy('id')
                                                  ->all(),
                                              function ($element) {
                                                  /**
                                                   * @var User $element
                                                   */
                                                  return $element->userData->name . ' ' . $element->userData->surname;
                                              }
                                          )
                                      );
                        ?>
                        
                        <?php
                            echo $form->field($addRole, 'part');
                        ?>
                        
                        <?php
                            echo $form->field($addRole, 'code');
                        ?>
                        
                        <?php
                            echo $form->field($addRole, 'iri');
                        ?>
                        
                        <?php
                            echo $form->field($addRole, 'society');
                        ?>
                        
                        <?php
                            echo $form->field($addRole, 'intellectual_property_id')
                                      ->hiddenInput(
                                          [
                                              'value' => $property->id,
                                          ]
                                      )
                                      ->label(false);
                        ?>
                    
                    </div>
                    <div class="modal-footer btn-submit-blue">
                        <?php
                            echo Html::submitButton(
                                'OK'
                            );
                        ?>
                    </div>
                    <?php
                        $form::end();
                    ?>
                </div>
            </div>
        </div>
        
        
        <!-- Modal Update -->
        <div class="modal fade" id="update-role-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        
        </div>
        <?php
    }
?>