<?php
    
    /**
     * @var UserData               $userData
     * @var UserPassport           $userPassport
     * @var yii\web\View           $this
     * @var IntellectualProperty[] $table
     */
    
    use common\models\User;
    use frontend\models\UserData;
    use frontend\models\UserPassport;
    use frontend\models\IntellectualProperty;
    use yii\helpers\Html;
    use yii\widgets\ActiveForm;
    use yii\widgets\Pjax;
    
    $this->title = 'My Yii Application';
    /**
     * @var User $user
     */
    $user = \Yii::$app->user->identity;
?>
<div class="style cab_content_list active-cab">
    <?php
        echo $this->render(
            '_personal_form',
            [
                'userData' => $userData,
            ]
        );
        echo $this->render(
            '_passport_form',
            [
                'userPassport' => $userPassport,
            ]
        );
    ?>
    
    <div class="style table-forms tables-1">
        <div class="title_forms">Список творів</div>
        <div class="btn-submit-blue">
            <?php echo Html::button(
                'Добавить',
                [
                    'type'        => 'button',
                    'class'       => 'add-button',
                    'data-toggle' => 'modal',
                    'data-target' => '#add-composition-modal',
                ]
            ) ?>
        </div>
        <div class="style table-forms-wrapp">
            <?php
                Pjax::begin(
                    [
                        'id' => 'int-prop-greed',
                    ]
                );
            ?>
            <table class="table-1" cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td>№<br/>п/п</td>
                    <td>Назва</td>
                    <td>Дата реєстрації</td>
                    <td>Жанр</td>
                    <td>Роль</td>
                    <td>Процент долі</td>
                    <td>Нараховано</td>
                    <td>К-ть відтворень</td>
                </tr>
                <?php
                    $i = 1;
                    foreach ($table as $row) {
                        ?>
                        <tr>
                            <td><?= $i; ?></td>
                            <td>
                                <?php
                                    echo Html::a($row->title,
                                                 [
                                                     'sales',
                                                     'id' => $row->id,
                                                 ]
                                    );
                                ?>
                            </td>
                            <td><?= $row->registration_date ?></td>
                            <td><?= $row->genre ?></td>
                            <td>
                                <?php
                                    if (!empty( $row->creativeRole )) {
                                        echo $row->creativeRole->title;
                                    } elseif ($user->isAdmin()) {
                                        echo '-';
                                    } else {
                                        echo 'У Вас немає ролі в даному ОІВ';
                                    }
                                ?>
                            </td>
                            <td>
                                <?php
                                    if (!empty( $row->creativeRole )) {
                                        echo $row->creativeRole->part . '%';
                                    } else {
                                        echo '-';
                                    }
                                ?>
                            </td>
                            <td>
                                <?php
                                    if (!empty( $row->creativeRole )) {
                                        $sum = 0;
                                        foreach ($row->reports as $report) {
                                            $sum += $report->sum;
                                        }
                                        echo( $sum * $row->creativeRole->part / 100 );
                                        unset( $sum );
                                    } else {
                                        echo '-';
                                    }
                                ?>
                            </td>
                            <td>
                                <?php
                                    $sum = 0;
                                    foreach ($row->reports as $report) {
                                        $sum += $report->count;
                                    }
                                    echo $sum;
                                    unset( $sum );
                                ?>
                            </td>
                        </tr>
                        <?php
                        $i++;
                    }
                ?>
            </table>
            <?php
                Pjax::end();
            ?>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="add-composition-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">Додати твір</h4>
            </div>
            <?php
                $form = ActiveForm::begin(
                    [
                        'action' => 'add-int-prop',
                        'id'     => 'add-int-prop-form',
                    ]
                );
                $addIntProp = new IntellectualProperty();
            ?>
            <div class="modal-body forms-cabinet forms-2">
                
                
                <?php
                    echo $form->field($addIntProp, 'title');
                ?>
                
                <?php
                    echo $form->field($addIntProp, 'registration_date')
                              ->textInput(
                                  [
                                      'class' => '_datepicker form-control',
                                  ]
                              );
                ?>
                
                <?php
                    echo $form->field($addIntProp, 'genre');
                ?>
                
                <?php
                    echo $form->field($addIntProp, 'author_role');
                ?>
            
            </div>
            <div class="modal-footer btn-submit-blue">
                <?php
                    echo Html::submitButton(
                        'OK'
                    );
                ?>
            </div>
            <?php
                $form::end();
            ?>
        </div>
    </div>
</div>

