<?php
    use common\models\User;
    use frontend\models\Report;
    use yii\helpers\Html;
    use yii\web\View;
    
    /**
     * @var View     $this
     * @var Report[] $reports
     * @var User $user
     */
    $user = \Yii::$app->user->identity;
?>
<div class="style cab_content_list">
    <div class="title_forms">Мої надходження</div>
    <div class="style table-forms-wrapp">
        <table class="table-1" cellpadding="0" cellspacing="0" border="0">
            <tr>
                <td>№<br/>п/п</td>
                <td>Користувач</td>
                <td>Твір</td>
                <td>Кількість сповіщень</td>
                <td>Перерахована сума</td>
            </tr>
            <?php
                foreach ($reports as $index => $report) {
                  if ($user->isAdmin()) {
                    $sum = $report->sum;
                  } else {
                    $sum = $report->sum * $report->intellectualProperty->creativeRoles[0]->part /100;
                  }
                    ?>
                    <tr>
                        <?php
                            echo Html::tag('td', ++$index);
                            echo Html::tag('td', $report->user);
                            echo Html::tag('td', $report->intellectualProperty->title);
                            echo Html::tag('td', $report->count);
                            echo Html::tag('td', $sum);
                        ?>
                    </tr>
                    <?php
                }
                
            ?>
        </table>
    </div>
</div>
