<?php
    /**
     * @var CreativeRole $model
     */
    use common\models\User;
    use frontend\models\CreativeRole;
    use yii\helpers\ArrayHelper;
    use yii\helpers\Html;
    use yii\widgets\ActiveForm;
?>

<div class="modal-dialog" role="document">
<div class="modal-content">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabel">Редагувати роль</h4>
    </div>
    <?php
        $form = ActiveForm::begin(
            [
                'action' => 'update-role?id=' . $model->id,
                'id'     => 'update-role-form',
            ]
        );

    ?>
    <div class="modal-body forms-cabinet forms-2">
        
        
        
        <?php
            echo $form->field($model, 'title');
        ?>

        <?php
            echo $form->field($model, 'user_id')
                      ->dropDownList(
                          ArrayHelper::getColumn(
                              User::find()
                                  ->joinWith('userData')
                                  ->indexBy('id')
                                  ->all(),
                              function ($element) {
                                  /**
                                   * @var User $element
                                   */
                                  return $element->userData->name . ' ' . $element->userData->surname;
                              }
                          )
                      );
        ?>
        
        <?php
            echo $form->field($model, 'part');
        ?>
        
        <?php
            echo $form->field($model, 'code');
        ?>
        
        <?php
            echo $form->field($model, 'iri');
        ?>
        
        <?php
            echo $form->field($model, 'society');
            echo $form->field($model, 'id')->hiddenInput()->label(false);
        ?>
    
    </div>
  <div class="clearfix"></div>
    <div class="modal-footer btn-submit-blue">
        <?php
            echo Html::submitButton(
                'OK'
            );
        ?>
    </div>
    <?php
        $form::end();
    ?>
</div>
</div>
