<?php
    use frontend\models\UserData;
    use yii\helpers\Html;
    use yii\widgets\ActiveForm;
    use yii\widgets\MaskedInput;
    use yii\widgets\Pjax;
    
    /**
     * @var UserData     $userData
     * @var yii\web\View $this
     */
    Pjax::begin(
        [
            'options' => [
                'class' => 'pjax_container forms-cabinet forms-1',
            ],
        ]
    );
?>
        <div class="title_forms">особисті данні</div>
        <?php
            $form = ActiveForm::begin(
                [
                    'id'     => 'personal-form',
                    'action' => [ 'cabinet/personal' ],
                ]
            );
            echo $form->field(
                $userData,
                'surname',
                [
                    'options' => [
                        'class' => 'input-wrapp-320',
                    ],
                ]
            )
                      ->textInput();
            echo $form->field(
                $userData,
                'name',
                [
                    'options' => [
                        'class' => 'input-wrapp-320',
                    ],
                ]
            )
                      ->textInput();
            echo $form->field(
                $userData,
                'patronymic',
                [
                    'options' => [
                        'class' => 'input-wrapp-320',
                    ],
                ]
            )
                      ->textInput();
            echo $form->field(
                $userData,
                'phone',
                [
                    'options' => [
                        'class' => 'input-wrapp-320',
                    ],
                ]
            )
                      ->widget(
                          MaskedInput::className(),
                          [
                              'mask'    => '+38 (099) 999-99-99',
                              'options' => [
                                  'placeholder' => '+38 (0XX) XXX-XX-XX',
                              ],
                          ]
                      );
            echo $form->field(
                $userData,
                'email',
                [
                    'options' => [
                        'class' => 'input-wrapp-320',
                    ],
                ]
            )
                      ->textInput();
            echo $form->field(
                $userData,
                'inn',
                [
                    'options' => [
                        'class' => 'input-wrapp-320',
                    ],
                ]
            )
                      ->textInput();
        ?>
        <div class="input-wrapp btn-submit-blue">
            <?php
                echo Html::submitButton('Зберегти');
            ?>
        </div>
        <?php
            $form::end();
        ?>
<?php
    Pjax::end();
?>