<?php

namespace frontend\models;

use common\models\User;

/**
 * This is the model class for table "user_passport".
 *
 * @property integer $id
 * @property integer $user_id
 * @property string $series
 * @property string $number
 * @property string $birthday
 * @property string $given_by
 *
 * @property User $user
 */
class UserPassport extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'user_passport';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_id'], 'integer'],
            [['given_by'], 'string'],
            [['series', 'number', 'birthday'], 'string', 'max' => 255],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::className(), 'targetAttribute' => ['user_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'User ID',
            'series' => 'Серія',
            'number' => '№',
            'birthday' => 'Дата народження',
            'given_by' => 'Ким виданий',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }
}
