<?php
    
    namespace frontend\models;
    
    use common\models\User;
    
    /**
     * This is the model class for table "user_data".
     *
     * @property integer $id
     * @property integer $user_id
     * @property string  $name
     * @property string  $surname
     * @property string  $patronymic
     * @property string  $phone
     * @property string  $email
     * @property string  $inn
     * @property User    $user
     */
    class UserData extends \yii\db\ActiveRecord
    {
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'user_data';
        }
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [ 'user_id' ],
                    'integer',
                ],
                [
                    [
                        'name',
                        'surname',
                        'patronymic',
                        'phone',
                        'email',
                        'inn',
                    ],
                    'string',
                    'max' => 255,
                ],
                [
                    [ 'user_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => User::className(),
                    'targetAttribute' => [ 'user_id' => 'id' ],
                ],
                [
                    [ 'phone' ],
                    'match',
                    'pattern' => '/\+38\s\(\d{3}\)\s\d{3}-\d{2}-\d{2}/',
                ],
                [
                    ['email'],
                    'email',
                ]
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'id'         => 'ID',
                'user_id'    => 'User ID',
                'name'       => 'Ім\'я',
                'surname'    => 'Прізвище',
                'patronymic' => 'По батькові',
                'phone'      => 'Телефон',
                'email'      => 'Email',
                'inn'        => 'ІНН',
            ];
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getUser()
        {
            return $this->hasOne(User::className(), [ 'id' => 'user_id' ]);
        }
    }
