<?php
    
    namespace frontend\models;
    
    /**
     * This is the model class for table "report".
     *
     * @property integer              $id
     * @property integer              $intellectual_property_id
     * @property string               $title
     * @property string               $music_author
     * @property string               $text_author
     * @property integer              $time
     * @property integer              $total_time
     * @property double               $royalty
     * @property integer              $count
     * @property string               $user
     * @property float                $sum
     * @property IntellectualProperty $intellectualProperty
     */
    class Report extends \yii\db\ActiveRecord
    {
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'report';
        }
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'intellectual_property_id',
                        'time',
                        'total_time',
                        'count',
                    ],
                    'integer',
                ],
                [
                    [
                        'royalty',
                        'sum',
                    ],
                    'number',
                ],
                [
                    [
                        'title',
                        'music_author',
                        'text_author',
                        'user',
                    ],
                    'string',
                    'max' => 255,
                ],
                [
                    [ 'intellectual_property_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => IntellectualProperty::className(),
                    'targetAttribute' => [ 'intellectual_property_id' => 'id' ],
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'id'                       => 'ID',
                'intellectual_property_id' => 'Твір',
                'title'                    => 'Title',
                'music_author'             => 'Music Author',
                'text_author'              => 'Text Author',
                'time'                     => 'Time',
                'total_time'               => 'Total Time',
                'royalty'                  => 'Royalty',
                'count'                    => 'Кількість сповіщень',
                'sum'                      => 'Перерахована сума',
                'user'                     => 'Користувач',
            ];
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getIntellectualProperty()
        {
            return $this->hasOne(IntellectualProperty::className(), [ 'id' => 'intellectual_property_id' ]);
        }
        
        public function beforeSave($insert)
        {
            $this->royalty = $this->sum * 0.8 * 0.805;
            return parent::beforeSave($insert);
        }
    }
