<?php
    
    namespace frontend\models;
    
    use common\models\User;
    
    /**
     * This is the model class for table "intellectual_property".
     *
     * @property integer        $id
     * @property integer        $user_id
     * @property string         $title
     * @property integer        $creation_date
     * @property string         $code
     * @property string         $genre
     * @property integer        $registration_date
     * @property string         $contract
     * @property string         $type
     * @property CreativeRole[] $creativeRoles
     * @property CreativeRole   $creativeRole
     * @property User           $user
     * @property Report[]       $reports
     */
    class IntellectualProperty extends \yii\db\ActiveRecord
    {
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'intellectual_property';
        }
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'user_id',
                    ],
                    'integer',
                ],
                [
                    [
                        'creation_date',
                        'registration_date',
                        'title',
                        'code',
                        'genre',
                        'contract',
                        'type',
                        'author_role',
                    ],
                    'string',
                    'max' => 255,
                ],
                [
                    [ 'user_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => User::className(),
                    'targetAttribute' => [ 'user_id' => 'id' ],
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'id'                => 'ID',
                'user_id'           => 'User ID',
                'title'             => 'Назва',
                'creation_date'     => 'Дата створення',
                'code'              => 'Шифр',
                'genre'             => 'Жанр',
                'registration_date' => 'Дата реєстрації',
                'contract'          => 'Договір',
                'type'              => 'Тип',
                'author_role'       => 'Роль автора',
            ];
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getCreativeRoles()
        {
            return $this->hasMany(CreativeRole::className(), [ 'intellectual_property_id' => 'id' ]);
        }
        
        public function getCreativeRole()
        {
            return $this->hasOne(CreativeRole::className(), [ 'intellectual_property_id' => 'id' ])
                        ->where([ 'creative_role.user_id' => \Yii::$app->user->id ]);
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getUser()
        {
            return $this->hasOne(User::className(), [ 'id' => 'user_id' ]);
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getReports()
        {
            return $this->hasMany(Report::className(), [ 'intellectual_property_id' => 'id' ]);
        }
    }
