<?php
    
    namespace frontend\models;
    
    use common\models\User;
    
    /**
     * This is the model class for table "creative_role".
     *
     * @property integer              $id
     * @property integer              $intellectual_property_id
     * @property string               $title
     * @property double               $part
     * @property string               $code
     * @property string               $iri
     * @property integer              $user_id
     * @property string               $society
     * @property IntellectualProperty $intellectualProperty
     * @property User                 $user
     */
    class CreativeRole extends \yii\db\ActiveRecord
    {
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'creative_role';
        }
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    ['user_id'],
                    'required',
                ],
                [
                    [
                        'intellectual_property_id',
                        'user_id',
                    ],
                    'integer',
                ],
                [
                    [ 'part' ],
                    'number',
                ],
                [
                    [
                        'title',
                        'code',
                        'iri',
                        'society',
                    ],
                    'string',
                    'max' => 255,
                ],
                [
                    [ 'intellectual_property_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => IntellectualProperty::className(),
                    'targetAttribute' => [ 'intellectual_property_id' => 'id' ],
                ],
                [
                    [ 'user_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => User::className(),
                    'targetAttribute' => [ 'user_id' => 'id' ],
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'id'                       => 'ID',
                'intellectual_property_id' => 'Intellectual Property ID',
                'title'                    => 'Творча роль',
                'part'                     => 'Доля %',
                'code'                     => 'Код',
                'iri'                      => 'IPI',
                'society'                  => 'Товариство',
                'user_id'                  => 'ПІБ',
            ];
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getIntellectualProperty()
        {
            return $this->hasOne(IntellectualProperty::className(), [ 'id' => 'intellectual_property_id' ]);
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getUser()
        {
            return $this->hasOne(User::className(), [ 'id' => 'user_id' ]);
        }
    }
