<?php
    
    use yii\db\Migration;
    
    class m161230_101523_big_migration extends Migration
    {
        public function safeUp()
        {
            // Creative role
            $this->truncateTable('creative_role');
            $this->dropColumn('creative_role', 'name');
            $this->addColumn(
                'creative_role',
                'user_id',
                $this->integer()
                     ->notNull()
            );
            $this->addForeignKey(
                'creative_role_user_fk',
                'creative_role',
                'user_id',
                'user',
                'id',
                'CASCADE',
                'CASCADE'
            );
            
            // Intellectual property
            $this->dropColumn('intellectual_property', 'percent');
            $this->dropColumn('intellectual_property', 'calculated');
            $this->dropColumn('intellectual_property', 'play_count');
            
            // Report
            $this->dropColumn('report', 'artist');
        }
        
        public function safeDown()
        {
            // Creative role
            $this->addColumn('creative_role', 'name', $this->string());
            $this->dropColumn('creative_role', 'user_id');
            
            // Intellectual property
            $this->addColumn('intellectual_property', 'percent', $this->decimal());
            $this->addColumn('intellectual_property', 'calculated', $this->decimal());
            $this->addColumn('intellectual_property', 'play_count', $this->integer());
    
            // Report
            $this->addColumn('report', 'artist', $this->string());
        }
    }
