<?php

use yii\db\Migration;

class m161226_111521_report extends Migration
{
    public function up()
    {
        $this->createTable('report', [
            'id' => $this->primaryKey(),
            'intellectual_property_id' => $this->integer(),
            'title' => $this->string(255),
            'artist' => $this->string(255),
            'music_author' => $this->string(255),
            'text_author' => $this->string(255),
            'time' => $this->integer(), // seconds
            'total_time' => $this->integer(), // seconds
            'royalty' => $this->double(),
            'count' => $this->integer(),
        ]);
        $this->addForeignKey('report_fk', 'report', 'intellectual_property_id', 'intellectual_property', 'id', 'CASCADE', 'CASCADE');
    }

    public function down()
    {
        $this->dropForeignKey('report_fk', 'report');
        $this->dropTable('report');
    }
}
