<?php
    
    use yii\db\Migration;
    
    class m161226_105932_creative_role extends Migration
    {
        public function up()
        {
            $this->createTable(
                'creative_role',
                [
                    'id' => $this->primaryKey(),
                    'intellectual_property_id' => $this->integer(),
                    'title' => $this->string(255),
                    'name' => $this->string(255),
                    'part' => $this->double(),
                    'code' => $this->string(255),
                    'iri' => $this->string(255),
                    'society' => $this->string(255),
                ]
            );
            $this->addForeignKey(
                'creative_role_fk',
                'creative_role',
                'intellectual_property_id',
                'intellectual_property',
                'id',
                'CASCADE',
                'CASCADE'
            );
    }
        
        public function down()
        {
            $this->dropForeignKey('creative_role_fk',
                                  'creative_role');
            $this->dropTable('creative_role');
        }
    }
