<?php

use yii\db\Migration;

class m161226_104633_intellectual_property extends Migration
{
    public function up()
    {
        $this->createTable('intellectual_property', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer(),
            'title' => $this->string(255),
            'creation_date' => $this->integer(),
            'code' => $this->string(255),
            'genre' => $this->string(255),
            'registration_date' => $this->integer(),
            'contract' => $this->string(255),
            'type' => $this->string(),
        ]);
        $this->addForeignKey('intellectual_property_fk', 'intellectual_property', 'user_id', 'user', 'id', 'CASCADE', 'CASCADE');
    }

    public function down()
    {
        $this->dropForeignKey('intellectual_property_fk', 'intellectual_property');
        $this->dropTable('intellectual_property');
    }
}
