<?php
    
    use artweb\artbox\modules\catalog\models\TaxGroup;
    use artweb\artbox\modules\catalog\models\TaxOptionLang;
    use yii\helpers\Html;
    
    /**
     * @var yii\web\View                                $this
     * @var artweb\artbox\modules\catalog\models\TaxOption $model
     * @var TaxGroup                                    $group
     * @var TaxOptionLang[]                             $modelLangs
     */
    $this->title = Yii::t('rubrication', 'Create Tax Option');
    $this->params[ 'breadcrumbs' ][] = [
        'label' => $group->level ? Yii::t('rubrication', 'Modification Groups') : Yii::t('rubrication', 'Product Groups'),
        'url'   => [
            'tax-group/index',
            'level' => $group->level,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = [
        'label' => $group->lang->title,
        'url'   => [
            'tax-group/update',
            'id'    => $group->id,
            'level' => $group->level,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = [
        'label' => Yii::t('rubrication', 'Options for group {group}', [ 'group' => $group->lang->title ]),
        'url'   => [
            'index',
            'group' => $group->id,
            'level' => $group->level,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="tax-option-create">
    
    <h1><?= Html::encode($this->title) ?></h1>
    
    <?= $this->render('_form', [
        'model'       => $model,
        'modelLangs' => $modelLangs,
        'group'       => $group,
    ]) ?>

</div>
