<?php
    
    namespace artweb\artbox\modules\blog\controllers;
    
    use Yii;
    use artweb\artbox\modules\blog\models\BlogCategory;
    use artweb\artbox\modules\blog\models\BlogCategorySearch;
    use yii\helpers\ArrayHelper;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;
    use yii\filters\VerbFilter;
    
    /**
     * BlogCategoryController implements the CRUD actions for BlogCategory model.
     */
    class BlogCategoryController extends Controller
    {
        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'verbs' => [
                    'class'   => VerbFilter::className(),
                    'actions' => [
                        'delete' => [ 'POST' ],
                    ],
                ],
            ];
        }
        
        /**
         * Lists all BlogCategory models.
         *
         * @return mixed
         */
        public function actionIndex()
        {
            $searchModel = new BlogCategorySearch();
            $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
            
            return $this->render(
                'index',
                [
                    'searchModel'  => $searchModel,
                    'dataProvider' => $dataProvider,
                ]
            );
        }
        
        /**
         * Displays a single BlogCategory model.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionView($id)
        {
            return $this->render(
                'view',
                [
                    'model' => $this->findModel($id),
                ]
            );
        }
        
        /**
         * Creates a new BlogCategory model.
         * If creation is successful, the browser will be redirected to the 'view' page.
         *
         * @return mixed
         */
        public function actionCreate()
        {
            $model = new BlogCategory();
            $model->generateLangs();
            $parentCategories = ArrayHelper::map(
                BlogCategory::find()
                            ->joinWith('lang')
                            ->where(
                                [
                                    'parent_id' => 0,
                                ]
                            )
                            ->all(),
                'id',
                'lang.title'
            );
            
            if ($model->load(Yii::$app->request->post())) {
                $model->loadLangs(\Yii::$app->request);
                if ($model->save() && $model->transactionStatus) {
                    return $this->redirect(
                        [
                            'view',
                            'id' => $model->id,
                        ]
                    );
                }
            }
            return $this->render(
                'create',
                [
                    'model'            => $model,
                    'modelLangs'       => $model->modelLangs,
                    'parentCategories' => $parentCategories,
                ]
            );
            
        }
        
        /**
         * Updates an existing BlogCategory model.
         * If update is successful, the browser will be redirected to the 'view' page.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionUpdate($id)
        {
            $model = $this->findModel($id);
            $model->generateLangs();
            $parentCategories = ArrayHelper::map(
                BlogCategory::find()
                            ->joinWith('lang')
                            ->where(
                                [
                                    'parent_id' => 0,
                                ]
                            )
                            ->andWhere(
                                [
                                    '!=',
                                    BlogCategory::tableName() . '_id',
                                    $model->id,
                                ]
                            )
                            ->all(),
                'id',
                'lang.title'
            );
            
            if ($model->load(Yii::$app->request->post())) {
                $model->loadLangs(\Yii::$app->request);
                if ($model->save() && $model->transactionStatus) {
                    return $this->redirect(
                        [
                            'view',
                            'id' => $model->id,
                        ]
                    );
                }
            }
            return $this->render(
                'update',
                [
                    'model'            => $model,
                    'modelLangs'       => $model->modelLangs,
                    'parentCategories' => $parentCategories,
                ]
            );
            
        }
        
        /**
         * Deletes an existing BlogCategory model.
         * If deletion is successful, the browser will be redirected to the 'index' page.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionDelete($id)
        {
            $this->findModel($id)
                 ->delete();
            
            return $this->redirect([ 'index' ]);
        }
        
        /**
         * Finds the BlogCategory model based on its primary key value.
         * If the model is not found, a 404 HTTP exception will be thrown.
         *
         * @param integer $id
         *
         * @return BlogCategory the loaded model
         * @throws NotFoundHttpException if the model cannot be found
         */
        protected function findModel($id)
        {
            if (( $model = BlogCategory::findOne($id) ) !== NULL) {
                return $model;
            } else {
                throw new NotFoundHttpException('The requested page does not exist.');
            }
        }
    }
