<?php
    
    namespace artweb\artbox\models;
    
    use yii\base\Model;
    use yii\data\ActiveDataProvider;
    
    /**
     * OrderSearch represents the model behind the search form about `\artweb\artbox\models\Order`.
     */
    class OrderSearch extends Order
    {
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'id',
                        'user_id',
                        'delivery',
                        'payment',
                        'status',
                    ],
                    'integer',
                ],
                [
                    [
                        'name',
                        'email',
                        'phone',
                    ],
                    'safe',
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function scenarios()
        {
            // bypass scenarios() implementation in the parent class
            return Model::scenarios();
        }
        
        /**
         * Creates data provider instance with search query applied
         *
         * @param array $params
         *
         * @return ActiveDataProvider
         */
        public function search($params)
        {
            $query = Order::find();
            
            // add conditions that should always apply here
            
            $dataProvider = new ActiveDataProvider(
                [
                    'query' => $query,
                ]
            );
            
            $this->load($params);
            
            if (!$this->validate()) {
                // uncomment the following line if you do not want to return any records when validation fails
                // $query->where('0=1');
                return $dataProvider;
            }
            
            // grid filtering conditions
            $query->andFilterWhere(
                [
                    'id'       => $this->id,
                    'user_id'  => $this->user_id,
                    'delivery' => $this->delivery,
                    'payment'  => $this->payment,
                    'status'   => $this->status,
                ]
            );
            
            $query->andFilterWhere(
                [
                    'like',
                    'name',
                    $this->name,
                ]
            )
                  ->andFilterWhere(
                      [
                          'like',
                          'email',
                          $this->email,
                      ]
                  )
                  ->andFilterWhere(
                      [
                          'like',
                          'phone',
                          $this->phone,
                      ]
                  );
            
            return $dataProvider;
        }
    }
