<?php
    
    namespace artweb\artbox\controllers;
    
    use Yii;
    use artweb\artbox\models\User;
    use artweb\artbox\models\UserSearch;
    use yii\filters\AccessControl;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;
    use yii\filters\VerbFilter;
    use yii\web\Response;
    use yii\widgets\ActiveForm;
    
    /**
     * UserController implements the CRUD actions for User model.
     */
    class UserController extends Controller
    {
        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            
            return [
                'verbs'  => [
                    'class'   => VerbFilter::className(),
                    'actions' => [
                        'delete' => [ 'POST' ],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::className(),
                    'rules' => [
                        [
                            'allow' => true,
                            'roles' => [ 'admin' ],
                        ],
                    ],
                ],
            ];
        }
        
        /**
         * Lists all User models.
         *
         * @return mixed
         */
        public function actionIndex()
        {
            $searchModel = new UserSearch();
            $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
            
            return $this->render(
                'index',
                [
                    'searchModel'  => $searchModel,
                    'dataProvider' => $dataProvider,
                ]
            );
        }
        
        /**
         * Displays a single User model.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionView($id)
        {
            return $this->render(
                'view',
                [
                    'model' => $this->findModel($id),
                ]
            );
        }
        
        /**
         * Creates a new User model.
         * If creation is successful, the browser will be redirected to the 'view' page.
         *
         * @return mixed
         */
        public function actionCreate()
        {
            $model = new User();
            if (Yii::$app->request->isAjax) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                $model->load(Yii::$app->request->post());
                return ActiveForm::validate($model);
            } elseif ($model->load(Yii::$app->request->post()) && $model->validate()) {
                $model->save();
                
                foreach ($model->role as $k => $role) {
                    $auth = Yii::$app->authManager;
                    $authorRole = $auth->getRole($role);
                    $auth->assign($authorRole, $model->id);
                }
                
                return $this->redirect(
                    [
                        'view',
                        'id' => $model->id,
                    ]
                );
            } else {
                return $this->render(
                    'create',
                    [
                        'model' => $model,
                    ]
                );
            }
        }
        
        /**
         * Updates an existing User model.
         * If update is successful, the browser will be redirected to the 'view' page.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionUpdate($id)
        {
            $model = $this->findModel($id);
            if (Yii::$app->request->isAjax) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                $model->load(Yii::$app->request->post());
                return ActiveForm::validate($model);
            } elseif ($model->load(Yii::$app->request->post()) && $model->validate()) {
                
                $model->save();
                
                return $this->redirect(
                    [
                        'view',
                        'id' => $model->id,
                    ]
                );
            } else {
                return $this->render(
                    'create',
                    [
                        'model' => $model,
                    ]
                );
            }
        }
        
        /**
         * Deletes an existing User model.
         * If deletion is successful, the browser will be redirected to the 'index' page.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionDelete($id)
        {
            $this->findModel($id)
                 ->delete();
            
            return $this->redirect([ 'index' ]);
        }
        
        /**
         * Finds the User model based on its primary key value.
         * If the model is not found, a 404 HTTP exception will be thrown.
         *
         * @param integer $id
         *
         * @return User the loaded model
         * @throws NotFoundHttpException if the model cannot be found
         */
        protected function findModel($id)
        {
            if (( $model = User::findOne($id) ) !== null) {
                return $model;
            } else {
                throw new NotFoundHttpException('The requested page does not exist.');
            }
        }
    }
