<?php
    
    use yii\helpers\Html;
    use yii\grid\GridView;
    
    /* @var $this yii\web\View */
    /* @var $searchModel artweb\artbox\models\ServiceSearch */
    /* @var $dataProvider yii\data\ActiveDataProvider */
    
    $this->title = Yii::t('app', 'Services');
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="service-index">
    
    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    
    <p>
        <?= Html::a(Yii::t('app', 'Create Service'), [ 'create' ], [ 'class' => 'btn btn-success' ]) ?>
    </p>
    <?= GridView::widget(
        [
            'dataProvider' => $dataProvider,
            'filterModel'  => $searchModel,
            'columns'      => [
                [ 'class' => 'yii\grid\SerialColumn' ],
                
                'id',
                'imageUrl:image',
                'created_at:date',
                
                [ 'class' => 'yii\grid\ActionColumn' ],
            ],
        ]
    ); ?>
</div>
