<?php
    
    namespace frontend\widgets;
    
    use artbox\catalog\models\VariantOptionExcl;
    
    class VariantOptionHelper
    {
        protected $options = [];
        
        public function addOption(VariantOptionExcl $option)
        {
            if (!array_key_exists($option->id, $this->options)) {
                $this->options[ $option->id ][ 'option' ] = $option;
                $this->options[ $option->id ][ 'variants' ] = new VariantHelper();
            }
        }
        
        public function getVariantContainer(VariantOptionExcl $option)
        {
            /**
             * @var \frontend\widgets\VariantHelper $variantHelper
             */
            $variantHelper = $this->options[ $option->id ][ 'variants' ];
            return $variantHelper;
        }
        
        public function getOptions()
        {
            return $this->options;
        }
    }