<?php
    
    namespace frontend\widgets;
    
    use artbox\catalog\models\Variant;
    
    class VariantHelper
    {
        /**
         * @var Variant[] $variants
         */
        protected $variants = [];
        
        public function addVariant(Variant $variant)
        {
            if (!array_key_exists($variant->id, $this->variants)) {
                $this->variants[ $variant->id ] = $variant;
            }
        }
        
        public function getVariants()
        {
            return $this->variants;
        }
        
        public function getVariant()
        {
            return $this->variants[ array_keys($this->variants)[ 0 ] ];
        }
    }