<?php
    use artbox\catalog\models\OptionGroup;
    use artbox\catalog\models\Product;
    use artbox\catalog\models\Variant;
    use artbox\core\components\SeoComponent;
    use artbox\core\helpers\ImageHelper;
    use frontend\models\Order;
    use frontend\widgets\OptionPicker;
    use yii\bootstrap\ActiveForm;
    use yii\bootstrap\Html;
    use yii\helpers\ArrayHelper;
    use yii\helpers\Url;
    use yii\web\View;
    
    /**
     * @var View         $this
     * @var Variant      $model
     * @var SeoComponent $seo
     * @var array        $groups
     * @var Product[]    $similar
     */
    $seo = \Yii::$app->get('seo');
    if (!empty($model->product->category)) {
        if (!empty($model->product->category->parent)) {
            $this->params[ 'breadcrumbs' ][] = [
                'label' => $model->product->category->parent->lang->title,
                'url'   => [
                    '/category/view',
                    'category' => $model->product->category->parent->lang->alias->value,
                ],
            ];
        }
        $this->params[ 'breadcrumbs' ][] = [
            'label' => $model->product->category->lang->title,
            'url'   => [
                '/category/view',
                'category' => $model->product->category->lang->alias->value,
            ],
        ];
    }
    $this->params[ 'breadcrumbs' ][] = $model->product->lang->title;
    $this->params[ 'breadcrumbs' ][] = $seo->title;
    $images = $model->product->images;
    if (!empty($model->product->image)) {
        array_unshift($images, $model->product->image);
    }
    if (!empty($model->image)) {
        array_unshift($images, $model->image);
    }
?>
<div id="content">
  <div class="container">
    <div class="row">
      <div class="col-md-12">
        
        <div class="row" id="productMain">
          <div class="col-sm-6">
            <div id="mainImage">
                <?php
                    if (!empty($images)) {
                        echo ImageHelper::set($images[ 0 ]->getPath())
                                        ->fillResize(555, 555)
                                        ->renderImage(
                                            [
                                                'class' => 'img-responsive',
                                                'alt'   => $model->lang->title,
                                                'title' => $model->lang->title,
                                            ]
                                        );
                    } else {
                        echo ImageHelper::set('@frontend/web/img/no-image.png')
                                        ->fillResize(555, 555)
                                        ->renderImage(
                                            [
                                                'class' => 'img-responsive',
                                                'alt'   => $model->lang->title,
                                                'title' => $model->lang->title,
                                            ]
                                        );
                    }
                ?>
            </div>
              
              <?php
                  if ($model->product->is('akcia')) {
                      ?>
                    <div class="ribbon sale">
                      <div class="theribbon">АКЦИЯ</div>
                      <div class="ribbon-background"></div>
                    </div>
                    <!-- /.ribbon -->
                      <?php
                  }
                  if ($model->product->is('new')) {
                      ?>
                    <div class="ribbon new">
                      <div class="theribbon">НОВОЕ</div>
                      <div class="ribbon-background"></div>
                    </div>
                    <!-- /.ribbon -->
                      <?php
                  }
                  if ($model->product->is('top')) {
                      ?>
                    <div class="ribbon top">
                      <div class="theribbon">ТОП</div>
                      <div class="ribbon-background"></div>
                    </div>
                    <!-- /.ribbon -->
                      <?php
                  }
              ?>
            
            <div class="row" id="thumbs">
                <?php
                    if (!empty($images)) {
                        foreach ($images as $image) {
                            echo Html::tag(
                                'div',
                                Html::a(
                                    ImageHelper::set($image->getPath())
                                               ->fillResize(70, 60)
                                               ->renderImage(
                                                   [
                                                       'class' => 'img-responsive',
                                                       'alt'   => $model->lang->title,
                                                       'title' => $model->lang->title,
                                                   ]
                                               ),
                                    ImageHelper::set($image->getPath())
                                               ->fillResize(555, 555)
                                               ->render(),
                                    [
                                        'class' => 'thumb',
                                    ]
                                ),
                                [
                                    'class' => 'col-xs-2',
                                ]
                            );
                        }
                    } else {
                        echo Html::tag(
                            'div',
                            Html::a(
                                ImageHelper::set('@frontend/web/img/no-image.png')
                                           ->fillResize(70, 60)
                                           ->renderImage(
                                               [
                                                   'class' => 'img-responsive',
                                                   'alt'   => $model->lang->title,
                                                   'title' => $model->lang->title,
                                               ]
                                           ),
                                ImageHelper::set('@frontend/web/img/no-image.png')
                                           ->fillResize(555, 555)
                                           ->render(),
                                [
                                    'class' => 'thumb',
                                ]
                            ),
                            [
                                'class' => 'col-xs-2',
                            ]
                        );
                    }
                ?>
            </div>
              <?php
                  if (!empty($model->product->video)) {
                      ?>
                    <div class="product-video">
                      <div class="h3">
                          <?php echo \Yii::t('app', 'Видеообзор продукта'); ?>
                      </div>
                      <div class="video-box">
                          <?php echo $model->product->video; ?>
                      </div>
                    </div>
                      <?php
                  }
              ?>
          </div>
          <div class="col-sm-6">
            <div class="box">
              <h1><?php echo $model->lang->title; ?></h1>
              <p class="no-margin"><?php echo $model->sku; ?></p>
              <p class="price">
                <span class="price-title">Цена:</span><?php echo $model->price ? : 0; ?> грн&ensp;
                  <?php
                      if ($model->canBuy()) {
                          echo Html::a(
                              Html::tag(
                                  'i',
                                  '',
                                  [
                                      'class' => 'fa fa-shopping-cart',
                                  ]
                              ) . \Yii::t('app', 'Добавить в корзину'),
                              '#',
                              [
                                  'class'   => 'btn btn-success add-to-basket',
                                  'data-id' => $model->id,
                              ]
                          );
                      } else {
                          echo Html::a(
                              \Yii::t('app', 'Нет в наличии'),
                              '#',
                              [
                                  'class'   => 'btn btn-info disabled',
                                  'data-id' => $model->id,
                              ]
                          );
                      }
                  ?>
                  <?php
                      if (\Yii::$app->user->isGuest) {
                          echo Html::button(
                              Html::tag('i', '', [ 'class' => 'fa fa-heart-o' ]),
                              [
                                  'title' => 'Добавить в избранное',
                                  'data'  => [
                                      'toggle'    => 'tooltip',
                                      'placement' => 'top',
                                  ],
                                  'class' => 'btn btn-default pull-right disabled',
                              ]
                          );
                      } elseif (in_array($model->id, \Yii::$app->user->identity->wishlist)) {
                          echo Html::button(
                              Html::tag('i', '', [ 'class' => 'fa fa-heart' ]),
                              [
                                  'title' => 'Убрать из избранного',
                                  'data'  => [
                                      'toggle'    => 'tooltip',
                                      'placement' => 'top',
                                      'product'   => $model->product->id,
                                      'variant'   => $model->id,
                                      'user'      => \Yii::$app->user->identity->getId(),
                                      'url'       => Url::to([ 'product/wishlist-rm' ]),
                                  ],
                                  'class' => 'wishlist-rm btn btn-success pull-right',
                              ]
                          );
                      } else {
                          echo Html::button(
                              Html::tag('i', '', [ 'class' => 'fa fa-heart-o' ]),
                              [
                                  'title' => 'Добавить в избранное',
                                  'data'  => [
                                      'toggle'    => 'tooltip',
                                      'placement' => 'top',
                                      'product'   => $model->product->id,
                                      'variant'   => $model->id,
                                      'user'      => \Yii::$app->user->identity->getId(),
                                      'url'       => Url::to([ 'product/wishlist-add' ]),
                                  ],
                                  'class' => 'wishlist-add btn btn-success pull-right',
                              ]
                          );
                      }
                  ?>
              </p>
              <hr>
                <?php
                    if ($model->canBuy()) {
                        echo Html::a(
                            Html::icon(
                                'phone',
                                [
                                    'prefix' => 'fa fa-',
                                ]
                            ) . \Yii::t('app', 'Купить в один клик'),
                            '#',
                            [
                                'data'  => [
                                    'toggle' => 'modal',
                                    'target' => '#oneclick-modal',
                                ],
                                'class' => 'btn btn-template-main',
                            ]
                        );
                    }
                ?>
            </div>
            <div class="product-variant-block">
                <?php
                    $helper = OptionPicker::getHelper($model->product);
                    $productVariantGroups = $helper->getGroups();
                    foreach ($productVariantGroups as $productVariantGroup) {
                        ?>
                      <div class="product-variant-group">
                        <p class="product-variant-group-title">
                            <?php
                                /**
                                 * @var \artbox\catalog\models\VariantOptionGroupExcl $productVariantGroupModel
                                 */
                                $productVariantGroupModel = $productVariantGroup[ 'group' ];
                                echo $productVariantGroupModel->lang->title . ": ";
                            ?>
                        </p>
                        <div class="product-variant-group-options">
                            <?php
                                /**
                                 * @var \frontend\widgets\VariantOptionHelper $variantOptionHelper
                                 */
                                $variantOptionHelper = $productVariantGroup[ 'options' ];
                                foreach ($variantOptionHelper->getOptions() as $option) {
                                    /**
                                     * @var \artbox\catalog\models\VariantOptionExcl $productVariantOptionModel
                                     */
                                    $productVariantOptionModel = $option[ 'option' ];
                                    /**
                                     * @var \frontend\widgets\VariantHelper $variantHelper
                                     */
                                    $variantHelper = $option[ 'variants' ];
                                    $variant = $variantHelper->getVariant();
                                    /**
                                     * @var \artbox\core\models\Image $img
                                     */
                                    $img = $productVariantOptionModel->image ? : $variant->image ? : null;
                                    echo Html::a(
                                        Html::tag(
                                            'div',
                                            $img ? ImageHelper::set($img->getPath())
                                                              ->fillResize(90, 55)
                                                              ->renderImage(
                                                                  [
                                                                      'alt'   => $productVariantOptionModel->lang->value,
                                                                      'title' => $productVariantOptionModel->lang->value,
                                                                      'class' => 'product-variant-group-option-img',
                                                                  ]
                                                              ) : $productVariantOptionModel->lang->value,
                                            [
                                                'class' => 'product-variant-group-option',
                                            ]
                                        ),
                                        [
                                            'variant/view',
                                            'id' => $variant->id,
                                        ]
                                    );
                                }
                            ?>
                        </div>
                      </div>
                        <?php
                    }
                ?>
            </div>
            <div class="box" id="details">
              <h2><?php echo \Yii::t('app', 'Описание товара'); ?></h2>
                <?php echo $model->lang->description ? : \Yii::t('app', 'Нет описания'); ?>
            </div>
            
            <div class="box" id="details">
              <h2><?php echo \Yii::t('app', 'Характеристики'); ?></h2>
                <?php
                    if (!empty($groups)) {
                        ?>
                      <table class="table">
                        <tbody>
                            <?php
                                foreach ($groups as $group) {
                                    foreach ($group as $optionGroup) {
                                        /**
                                         * @var OptionGroup $optionGroup
                                         */
                                        echo Html::tag(
                                            'tr',
                                            Html::tag(
                                                'td',
                                                $optionGroup->lang->title,
                                                [ 'class' => 'td-title' ]
                                            ) . Html::tag(
                                                'td',
                                                implode(
                                                    ', ',
                                                    ArrayHelper::getColumn(
                                                        $optionGroup->currentOptions,
                                                        'lang.value'
                                                    )
                                                )
                                            )
                                        );
                                    }
                                }
                            ?>
                        </tbody>
                      </table>
                        <?php
                    } else {
                        echo \Yii::t('app', 'Нет характеристик');
                    }
                ?>
            </div>
          </div>
        
        </div>
          
          <?php
              if (!empty($similar)) {
                  ?>
                <div class="heading text-center">
                  <h2><?php echo \Yii::t('app', 'Похожие товары'); ?></h2>
                </div>
                
                <div class="product-carousel">
                  <div class="homepage owl-carousel">
                      <?php
                          $newItemsArrays = array_chunk($similar, 4);
                          foreach ($newItemsArrays as $newItemsArray) {
                              ?>
                            <div class="products">
                                <?php
                                    foreach ($newItemsArray as $product) {
                                        echo $this->render(
                                            '@frontend/views/site/_slider_product',
                                            [
                                                'product' => $product,
                                            ]
                                        );
                                    }
                                ?>
                            </div>
                              <?php
                          }
                      ?>
                  </div>
                </div>
                  <?php
              }
          ?>
      </div>
      <!-- /.col-md-9 -->
    </div>
    <!-- /.row -->
  </div>
  <!-- /.container -->
</div>
<!-- /#content -->
<div class="modal fade" id="oneclick-modal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-sm">
    
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4 class="modal-title callback"><?php echo \Yii::t('app', 'Купить в один клик'); ?></h4>
      </div>
      <div class="modal-body">
          <?php
              $order = new Order(
                  [
                      'scenario'  => Order::SCENARIO_FAST,
                      'variantId' => $model->id,
                      'returnUrl' => \Yii::$app->request->absoluteUrl,
                  ]
              );
              $form = ActiveForm::begin(
                  [
                      'action' => [ 'checkout/fast' ],
                      'id'     => 'fast-buy-form',
                  ]
              );
              echo $form->field($order, 'variantId')
                        ->label(false)
                        ->hiddenInput();
              echo $form->field($order, 'returnUrl')
                        ->label(false)
                        ->hiddenInput();
              echo $form->field($order, 'name')
                        ->label(false)
                        ->textInput(
                            [
                                'placeholder' => $order->getAttributeLabel('name'),
                            ]
                        );
              echo $form->field($order, 'phone')
                        ->label(false)
                        ->textInput(
                            [
                                'placeholder' => $order->getAttributeLabel('phone'),
                            ]
                        );
              echo Html::tag(
                  'p',
                  Html::submitButton(
                      Html::icon(
                          'shopping-cart',
                          [
                              'prefix' => 'fa fa-',
                          ]
                      ) . \Yii::t('app', ' Отправить'),
                      [
                          'class' => 'btn btn-template-main',
                      ]
                  ),
                  [
                      'class' => 'text-center',
                  ]
              );
              $form::end();
          ?>
      </div>
    </div>
  </div>
</div>
