<?php
    /**
     * @var \yii\web\View                     $this
     * @var \artbox\catalog\models\Category[] $categories
     * @var \yii\data\ActiveDataProvider      $dataProvider
     */
    use artbox\catalog\models\Product;
    use yii\bootstrap\Html;
    use yii\widgets\LinkPager;
    use yii\widgets\ListView;
    
    $type = \Yii::$app->request->get('type');
    $seo = \Yii::$app->get('seo');
    $view = $this;
    $this->params[ 'breadcrumbs' ][] = $seo->title ? : \Yii::t(
        'app',
        'Все {type}',
        [
            'type' => ( $type === 'new' ) ? \Yii::t('app', 'новинки') : \Yii::t(
                'app',
                'акционные'
            ),
        ]
    );
?>
<div id="content">
  <div class="container">
    
    <div class="row">
      
      
      <!-- *** LEFT COLUMN ***
_________________________________________________________ -->
      
      <div class="col-sm-3">
        <div class="panel panel-default sidebar-menu">
          <div class="panel-body">
            <ul class="nav nav-pills nav-stacked category-menu">
              <li>
                  <?php
                      foreach ($categories as $category) {
                          echo Html::a(
                              $category->lang->title,
                              [
                                  'special/category',
                                  'type'     => $type,
                                  'category' => $category->lang->alias->value,
                              ]
                          );
                      }
                  ?>
              </li>
            </ul>
          </div>
        </div>
      </div>
      <!-- /.col-md-3 -->
      
      <!-- *** LEFT COLUMN END *** -->
      
      <!-- *** RIGHT COLUMN ***
_________________________________________________________ -->
      
      <div class="col-sm-9">
          
          <?php
              echo ListView::widget(
                  [
                      'options'      => [
                          'class' => 'row products',
                      ],
                      'itemOptions'  => [
                          'tag' => false,
                      ],
                      'layout'       => '{items}',
                      'dataProvider' => $dataProvider,
                      'itemView'     => function ($model) use ($view) {
                          /**
                           * @var Product $model
                           */
                          return $view->render(
                              '@frontend/views/category/_product_item',
                              [
                                  'product' => $model,
                              ]
                          );
                      },
                  ]
              );
              echo Html::tag(
                  'div',
                  LinkPager::widget(
                      [
                          'pagination' => $dataProvider->pagination,
                      ]
                  ),
                  [
                      'class' => 'pages',
                  ]
              );
          ?>
      
      </div>
      <!-- /.col-md-9 -->
      
      <!-- *** RIGHT COLUMN END *** -->
    
    </div>
  
  </div>
  <!-- /.container -->
</div>
<!-- /#content -->

