<?php
    /**
     * @var \yii\web\View                   $this
     * @var \artbox\catalog\models\Category $model
     * @var \yii\data\ActiveDataProvider    $dataProvider
     */
    use artbox\catalog\models\Product;
    use yii\bootstrap\Html;
    use yii\widgets\LinkPager;
    use yii\widgets\ListView;
    
    $seo = \Yii::$app->get('seo');
    $view = $this;
    $type = \Yii::$app->request->get('type');
    $this->params[ 'breadcrumbs' ][] = [
        'label' => \Yii::t(
            'app',
            'Все {type}',
            [
                'type' => ( $type === 'new' ) ? \Yii::t('app', 'новинки') : \Yii::t(
                    'app',
                    'акционные'
                ),
            ]
        ),
        'url'   => [
            'special/index',
            'type' => $type,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = $seo->title ? : ( ( $type === 'new' ) ? \Yii::t('app', 'Новинки') : \Yii::t(
            'app',
            'Акционные'
        ) ) . ' ' . $model->lang->title;
?>
<div id="content">
  <div class="container">
    
    <div class="row">
      
      <div class="col-sm-12">
          
          <?php
              echo ListView::widget(
                  [
                      'options'      => [
                          'class' => 'row products',
                      ],
                      'itemOptions'  => [
                          'tag' => false,
                      ],
                      'layout'       => '{items}',
                      'dataProvider' => $dataProvider,
                      'itemView'     => function ($model) use ($view) {
                          /**
                           * @var Product $model
                           */
                          return $view->render(
                              '@frontend/views/category/_product_item',
                              [
                                  'product' => $model,
                              ]
                          );
                      },
                  ]
              );
              echo Html::tag(
                  'div',
                  LinkPager::widget(
                      [
                          'pagination' => $dataProvider->pagination,
                      ]
                  ),
                  [
                      'class' => 'pages',
                  ]
              );
          ?>
      
      </div>
    
    </div>
  
  </div>
  <!-- /.container -->
</div>
<!-- /#content -->
