<?php
    
    /* @var $this yii\web\View */
    /* @var $form yii\bootstrap\ActiveForm */
    /* @var $loginForm LoginForm */
    /* @var $signupForm SignupForm */
    
    use artbox\order\models\LoginForm;
    use artbox\order\models\SignupForm;
    use yii\bootstrap\ActiveForm;
    use yii\bootstrap\Html;
    
    $this->title = \Yii::t('app', 'Новый аккаунт / Регистрация');
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div id="content">
  <div class="container">
    
    <div class="row">
      <div class="col-md-6">
        <div class="box">
          <h2 class="text-uppercase"><?php echo \Yii::t('app', 'Новый аккаунт'); ?></h2>
          
          <p class="lead"><?php echo \Yii::t('app', 'Не зарегистрированы?'); ?></p>
          <p class="text-muted"><?php echo \Yii::t(
                  'app',
                  'Если у вас есть вопросы, пожалуйста, {link}, наш центр обслуживания клиентов работает круглосуточно.',
                  [
                      'link' => Html::a(
                          \Yii::t('app', 'напишите нам'),
                          [
                              'page/view',
                              'id' => 17,
                          ]
                      ),
                  ]
              ); ?></p>
          
          <hr>
            
            <?php
                $formSignup = ActiveForm::begin();
                echo $formSignup->field($signupForm, 'username')
                                ->textInput();
                echo $formSignup->field($signupForm, 'email')
                                ->textInput();
                echo $formSignup->field($signupForm, 'password')
                                ->passwordInput();
                echo Html::tag(
                    'div',
                    Html::submitButton(
                        Html::icon(
                            'user-md',
                            [
                                'prefix' => 'fa fa-',
                            ]
                        ) . \Yii::t('app', 'Register'),
                        [
                            'class' => 'btn btn-template-main',
                        ]
                    ),
                    [
                        'class' => 'text-center',
                    ]
                );
                $formSignup::end();
            ?>
        </div>
      </div>
      
      <div class="col-md-6">
        <div class="box">
          <h2 class="text-uppercase"><?php echo \Yii::t('app', 'Войти'); ?></h2>
          
          <p class="lead"><?php echo \Yii::t('app', 'Уже зарегистрированы?'); ?></p>
          
          <hr>
          <p class="lead">Do you already have an account on one of these sites? Click the logo to log in with it here:</p>
            <?php echo \nodge\eauth\Widget::widget([ 'action' => 'site/login' ]); ?>
            <?php
                if (Yii::$app->getSession()
                             ->hasFlash('error')
                ) {
                    echo '<div class="alert alert-danger">' . Yii::$app->getSession()
                                                                       ->getFlash('error') . '</div>';
                }
                $formLogin = ActiveForm::begin();
                echo $formLogin->field($loginForm, 'username')
                               ->textInput();
                echo $formLogin->field($loginForm, 'password')
                               ->passwordInput();
                echo $formLogin->field($loginForm, 'rememberMe')
                               ->checkbox();
                echo Html::tag(
                    'div',
                    Html::submitButton(
                        Html::icon(
                            'sign-in',
                            [
                                'prefix' => 'fa fa-',
                            ]
                        ) . \Yii::t('app', 'Login'),
                        [
                            'class' => 'btn btn-template-main',
                        ]
                    ),
                    [
                        'class' => 'text-center',
                    ]
                );
                $formSignup::end();
            ?>
        </div>
      </div>
    
    </div>
    <!-- /.row -->
  
  </div>
  <!-- /.container -->
</div>