<?php
    use artbox\catalog\models\Brand;
    use artbox\catalog\models\Category;
    use artbox\catalog\models\Product;
    use artbox\core\components\SeoComponent;
    use artbox\core\helpers\ImageHelper;
    use artbox\weblog\models\Article;
    use yii\bootstrap\Html;
    use yii\helpers\Url;
    use yii\web\View;
    
    /**
     * @var View         $this
     * @var Category[]   $categories
     * @var Product[]    $topItems
     * @var Product[]    $newItems
     * @var Product[]    $saleItems
     * @var Product[]    $historyItems
     * @var int          $brandCount
     * @var int          $productCount
     * @var Brand[]      $brands
     * @var SeoComponent $seo
     * @var Article[]    $articles
     */
    $this->title = 'My Yii Application';
    $seo = Yii::$app->get('seo');
?>
<section class="category-carousel-box">
  <!-- *** HOMEPAGE CAROUSEL ***
_________________________________________________________ -->
  <div class="container">
    
    <div class="row">
      <div class="col-sm-3">
          <?php
              echo $this->render(
                  '@frontend/views/layouts/_category_menu',
                  [
                      'isHome' => true,
                  ]
              );
          ?>
      </div>
      
      <div class="col-sm-9">
        <div class="home-carousel">
          
          <div class="dark-mask"></div>
          
          <div class="homepage owl-carousel">
            <div class="item">
                <img src="/img/acdc-main-banner.png">
            </div>
          </div>
          <!-- /.project owl-slider -->
        </div>
      </div>
    </div>
  </div>
  <!-- *** HOMEPAGE CAROUSEL END *** -->
</section>


<section>
  <div class="container">
      <?php
          if (!empty($newItems)) {
              ?>
            <div class="heading text-center">
              <h2><?php echo \Yii::t('app', 'Новинки'); ?></h2>
            </div>
            
            <div class="product-carousel">
              <div class="homepage owl-carousel">
                  <?php
                      $newItemsArrays = array_chunk($newItems, 4);
                      foreach ($newItemsArrays as $newItemsArray) {
                          ?>
                        <div class="products">
                            <?php
                                foreach ($newItemsArray as $product) {
                                    echo $this->render(
                                        '_slider_product',
                                        [
                                            'product' => $product,
                                        ]
                                    );
                                }
                            ?>
                        </div>
                          <?php
                      }
                  ?>
              </div>
            </div>
              <?php
          }
          if (!empty($saleItems)) {
              ?>
            <div class="heading text-center">
              <h2><?php echo \Yii::t('app', 'Акции'); ?></h2>
            </div>
            <div class="product-carousel">
              <div class="homepage owl-carousel">
                  <?php
                      $newItemsArrays = array_chunk($saleItems, 4);
                      foreach ($newItemsArrays as $newItemsArray) {
                          ?>
                        <div class="products">
                            <?php
                                foreach ($newItemsArray as $product) {
                                    echo $this->render(
                                        '_slider_product',
                                        [
                                            'product' => $product,
                                        ]
                                    );
                                }
                            ?>
                        </div>
                          <?php
                      }
                  ?>
              </div>
            </div>
              <?php
          }
          if (!empty($topItems)) {
              ?>
            <div class="heading text-center">
              <h2><?php echo \Yii::t('app', 'Топ'); ?></h2>
            </div>
            <div class="product-carousel">
              <div class="homepage owl-carousel">
                  <?php
                      $newItemsArrays = array_chunk($topItems, 4);
                      foreach ($newItemsArrays as $newItemsArray) {
                          ?>
                        <div class="products">
                            <?php
                                foreach ($newItemsArray as $product) {
                                    echo $this->render(
                                        '_slider_product',
                                        [
                                            'product' => $product,
                                        ]
                                    );
                                }
                            ?>
                        </div>
                          <?php
                      }
                  ?>
              </div>
            </div>
              <?php
          }
          if (!empty($historyItems)) {
              ?>
            <div class="heading text-center">
              <h2><?php echo \Yii::t('app', 'Недавно просматривали'); ?></h2>
            </div>
            <div class="product-carousel">
              <div class="homepage owl-carousel">
                  <?php
                      $newItemsArrays = array_chunk($historyItems, 4);
                      foreach ($newItemsArrays as $newItemsArray) {
                          ?>
                        <div class="products">
                            <?php
                                foreach ($newItemsArray as $product) {
                                    echo $this->render(
                                        '_slider_product',
                                        [
                                            'product' => $product,
                                        ]
                                    );
                                }
                            ?>
                        </div>
                          <?php
                      }
                  ?>
              </div>
            </div>
              <?php
          }
      ?>
  </div>
</section>

<section class="bar color-white no-mb">
  <div class="container">
    <div class="row showcase">
      <div class="col-md-4 col-sm-6">
        <div class="item">
          <div class="icon"><i class="fa fa-cubes"></i>
          </div>
          <h4><span class="counter"><?php echo $productCount; ?></span><br>
            
            Позиций товаров</h4>
        </div>
      </div>
      <div class="col-md-4 col-sm-6">
        <div class="item">
          <div class="icon"><i class="fa fa-tags"></i>
          </div>
          <h4><span class="counter"><?php echo $brandCount; ?></span><br>
            
            Брендов</h4>
        </div>
      </div>
      <div class="col-md-4 col-sm-6">
        <div class="item">
          <div class="icon"><i class="fa fa-copy"></i>
          </div>
          <h4><span class="counter">12</span> ... <span class="counter">36</span><br>
            
            Месяцев Гарантия </h4>
        </div>
      </div>
    </div>
    <!-- /.row -->
  </div>
  <!-- /.container -->
</section>
<!-- /.bar -->
<?php
    if (!empty($brands)) {
        ?>
      <section class="bar background-gray no-mb">
        <div class="container">
          <div class="row">
            <div class="col-md-12">
              <div class="heading text-center">
                <h2><?php echo \Yii::t('app', 'Бренды'); ?></h2>
              </div>
  
              <ul class="owl-carousel customers brand-carousel">
                  <?php
                      foreach ($brands as $brand) {
                          echo Html::tag(
                              'div',
                              Html::img(
                                  ImageHelper::set($brand->image->getPath())
                                             ->setWidth(150)
                                             ->render(),
                                  [
                                      'class' => 'img-responsive',
                                  ]
                              ),
                              [
                                  'class' => 'item',
                              ]
                          );
                      }
                  ?>
              </ul>
              <!-- /.owl-carousel -->
            </div>
          
          </div>
        </div>
      </section>
        <?php
    }
?>
<section class="bar background-white no-mb">
  <div class="container">
    
    <div class="col-md-12">
      <div class="heading text-center">
        <h2>Полезные статьи</h2>
      </div>
      
      <!-- *** BLOG HOMEPAGE ***
_________________________________________________________ -->
      
      <div class="row">
          
          <?php foreach ($articles as $article) { ?>
            <div class="col-md-3 col-sm-6">
              <div class="box-image-text blog">
                <div class="top">
                  <div class="image">
                      <?= ImageHelper::set(
                          $article->image ? $article->image->getPath() : '@frontend/web/img/no-image.png'
                      )
                                     ->cropResize(255, 192)
                                     ->renderImage(
                                         [
                                             'class' => 'img-responsive',
                                             'alt'   => $article->lang->title,
                                         ]
                                     ) ?>
                  </div>
                  <div class="bg"></div>
                  <div class="text">
                    <p class="buttons">
                      <a href="<?= Url::to(
                          [
                              'blog/article',
                              'id' => $article->id,
                          ]
                      ) ?>" class="btn btn-template-transparent-primary"><i class="fa fa-link"></i> <?php echo \Yii::t(
                              'app',
                              'Read more'
                          ); ?></a>
                    </p>
                  </div>
                </div>
                <div class="content">
                  <h4><a href="<?= Url::to(
                          [
                              'blog/article',
                              'id' => $article->id,
                          ]
                      ) ?>"><?= $article->lang->title; ?></a></h4>
                    <?php if ( !empty($article->category) ) { ?>
                  <p class="author-category"><a href="<?= Url::to(
                          [
                              'blog/category',
                              'id' => $article->category->id,
                          ]
                      ) ?>"><?= $article->category->lang->title ?></a>
                      <?php } ?>
                  </p>
                  <p class="intro"><?= $article->lang->body_preview; ?></p>
                  <p class="read-more">
                    <a href="<?= Url::to(
                        [
                            'blog/article',
                            'id' => $article->id,
                        ]
                    ) ?>" class="btn btn-template-main"><?php echo \Yii::t('app', 'Continue reading'); ?></a>
                  </p>
                </div>
              </div>
              <!-- /.box-image-text -->
            </div>
          <?php } ?>
      
      </div>
      <!-- /.row -->
      
      <!-- *** BLOG HOMEPAGE END *** -->
    
    </div>
  
  </div>
  <!-- /.container -->
</section>
<!-- /.bar -->


<section class="bar background-white no-mb">
  <div class="container">
    <div class="col-md-12">
        <?php echo $seo->text; ?>
    </div>
  </div>
</section>
