<?php
    use artbox\catalog\models\Product;
    use artbox\core\helpers\ImageHelper;
    use yii\helpers\Html;
    use yii\web\View;
    
    /**
     * @var View    $this
     * @var Product $product
     */
?>
<div class="col-md-3 col-sm-6">
  <div class="product">
    <div class="image">
        <?php
            echo Html::a(
                Html::img(
                    ImageHelper::set(
                        $product->image ? $product->image->getPath() : '@frontend/web/img/no-image.png'
                    )
                               ->fillResize(260, 260)
                               ->render(),
                    [
                        'class' => 'img-responsive-image1',
                    ]
                ),
                [
                    'product/view',
                    'id' => $product->id,
                ]
            );
        ?>
    </div>
  
    <div class="vcovers">
      <div class="content">
          <?php
              foreach ($product->variants as $variant) {
                  ?>
                <div class="vcover">
                    <?php
                        echo Html::a(
                            Html::img(
                                ImageHelper::set(
                                    $variant->image ? $variant->image->getPath() : '@frontend/web/img/no-image.png'
                                )
                                           ->fillResize(40, 40)
                                           ->render(),
                                [
                                    'class' => 'img-responsive-image1',
                                ]
                            ),
                            [
                                'variant/view',
                                'id' => $variant->id,
                            ]
                        );
                    ?>
                </div>
                  <?php
              }
          ?>
      </div>
    </div>
    <!-- /.image -->
    <div class="text">
      <h3>
          <?php
              echo Html::a(
                  $product->lang->title,
                  [
                      'product/view',
                      'id' => $product->id,
                  ]
              );
          ?>
      </h3>
      <p class="price">
          <?php
              if ($product->variants[ 0 ]->price_old) {
                  echo Html::tag('del', $product->variants[ 0 ]->price_old . ' грн.');
              }
              echo ( $product->variants[ 0 ]->price ? : 0 ) . ' грн.';
          ?></p>
      <p class="buttons">
          <?php
              if ($product->variants[ 0 ]->canBuy()) {
                  echo Html::a(
                      Html::tag(
                          'i',
                          '',
                          [
                              'class' => 'fa fa-shopping-cart',
                          ]
                      ) . \Yii::t('app', 'В корзину'),
                      '#',
                      [
                          'class'   => 'btn btn-template-main add-to-basket',
                          'data-id' => $product->variants[ 0 ]->id,
                      ]
                  );
              } else {
                  echo Html::a(
                      \Yii::t('app', 'Нет в наличии'),
                      '#',
                      [
                          'class'   => 'btn btn-info disabled',
                          'data-id' => $product->variants[ 0 ]->id,
                      ]
                  );
              }
          ?>
      </p>
    </div>
    <!-- /.text -->
      <?php
          if ($product->is('new')) {
              ?>
            <div class="ribbon new">
              <div class="theribbon"><?php echo \Yii::t('app', 'Новое'); ?></div>
              <div class="ribbon-background"></div>
            </div>
              <?php
          }
          if ($product->is('akcia')) {
              ?>
            <div class="ribbon sale">
              <div class="theribbon"><?php echo \Yii::t('app', 'Акция'); ?></div>
              <div class="ribbon-background"></div>
            </div>
              <?php
          }
          if ($product->is('top')) {
              ?>
            <div class="ribbon top">
              <div class="theribbon"><?php echo \Yii::t('app', 'Топ'); ?></div>
              <div class="ribbon-background"></div>
            </div>
              <?php
          }
      ?>
    
    <!-- /.ribbon -->
  </div>
  <!-- /.product -->
</div>