<?php
    /**
     * @var \yii\web\View                     $this
     * @var \common\models\SearchForm         $searchForm
     * @var \yii\data\ActiveDataProvider      $dataProvider
     * @var \artbox\catalog\models\Category[] $categories
     */
    use artbox\catalog\models\Product;
    use yii\bootstrap\ActiveForm;
    use yii\bootstrap\Html;
    use yii\widgets\LinkPager;
    use yii\widgets\ListView;
    
    $view = $this;
    
    $this->params[ 'breadcrumbs' ][] = \Yii::t('app', 'Поиск');
?>
<div id="content">
  <div class="container">
    <div class="row">
      <div class="col-sm-offset-3 col-sm-6">
          <?php
              $form = ActiveForm::begin(
                  [
                      'action' => [ 'index' ],
                      'method' => 'get',
                  ]
              );
              echo $form->field($searchForm, 'word')
                        ->textInput(
                            [
                                'placeholder' => $searchForm->getAttributeLabel('word'),
                                'name'        => 'word',
                            ]
                        )
                        ->label(false);
              $form::end();
          ?>
      </div>
    </div>
    <div class="row">
      <div class="col-xs-3">
        <div class="panel panel-default sidebar-menu">
          <div class="panel-body">
            <ul class="nav nav-pills nav-stacked category-menu">
                <?php
                    foreach ($categories as $category) {
                        echo Html::tag(
                            'li',
                            Html::a(
                                $category->lang->title,
                                [
                                    'category',
                                    'categoryId' => $category->id,
                                    'word'       => $searchForm->word,
                                ]
                            )
                        );
                    }
                ?>
            </ul>
          </div>
        </div>
      </div>
      <div class="col-xs-9">
          <?php
              if ($dataProvider) {
                  echo ListView::widget(
                      [
                          'options'      => [
                              'class' => 'row products',
                          ],
                          'itemOptions'  => [
                              'tag' => false,
                          ],
                          'layout'       => '{items}',
                          'dataProvider' => $dataProvider,
                          'itemView'     => function ($model) use ($view) {
                              /**
                               * @var Product $model
                               */
                              return $view->render(
                                  '@frontend/views/category/_product_item',
                                  [
                                      'product' => $model,
                                  ]
                              );
                          },
                      ]
                  );
                  echo Html::tag(
                      'div',
                      LinkPager::widget(
                          [
                              'pagination' => $dataProvider->pagination,
                          ]
                      ),
                      [
                          'class' => 'pages',
                      ]
                  );
              } else {
                  echo \Yii::t('app', 'Введите текст для поиска в строке выше.');
              }
          ?>
      </div>
    </div>
  </div>
</div>