<?php
    /**
     * @var \yii\web\View                     $this
     * @var \common\models\SearchForm         $searchForm
     * @var \yii\data\ActiveDataProvider      $dataProvider
     * @var \artbox\catalog\models\Category[] $categories
     * @var \artbox\catalog\models\Category   $category
     */
    use artbox\catalog\models\Product;
    use yii\bootstrap\ActiveForm;
    use yii\bootstrap\Html;
    use yii\widgets\LinkPager;
    use yii\widgets\ListView;
    
    $view = $this;
    
    $this->params[ 'breadcrumbs' ][] = [
        'label' => \Yii::t('app', 'Поиск'),
        'url'   => [
            'index',
            'word' => $searchForm->word,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = \Yii::t(
        'app',
        'Поиск по категории {category_name}',
        [
            'category_name' => $category->lang->title,
        ]
    );
?>
<div id="content">
  <div class="container">
    <div class="row">
      <div class="col-sm-offset-3 col-sm-6">
          <?php
              $form = ActiveForm::begin(
                  [
                      'action' => [
                          'category',
                          'categoryId' => $category->id,
                      ],
                      'method' => 'get',
                  ]
              );
              echo $form->field($searchForm, 'word')
                        ->textInput(
                            [
                                'placeholder' => $searchForm->getAttributeLabel('word'),
                                'name'        => 'word',
                            ]
                        )
                        ->label(false);
              $form::end();
          ?>
      </div>
    </div>
    <div class="row">
      <div class="col-xs-3">
        <div class="panel panel-default sidebar-menu">
          <div class="panel-body">
            <ul class="nav nav-pills nav-stacked category-menu">
                <?php
                    foreach ($categories as $item) {
                        echo Html::tag(
                            'li',
                            Html::a(
                                $item->lang->title,
                                [
                                    'category',
                                    'categoryId' => $item->id,
                                    'word'       => $searchForm->word,
                                ],
                                [
                                    'class' => ( ( $category->id === $item->id ) ? 'active' : '' ),
                                ]
                            )
                        );
                    }
                ?>
            </ul>
          </div>
        </div>
      </div>
      <div class="col-xs-9">
          <?php
              if ($dataProvider) {
                  echo ListView::widget(
                      [
                          'options'      => [
                              'class' => 'row products',
                          ],
                          'itemOptions'  => [
                              'tag' => false,
                          ],
                          'layout'       => '{items}',
                          'dataProvider' => $dataProvider,
                          'itemView'     => function ($model) use ($view) {
                              /**
                               * @var Product $model
                               */
                              return $view->render(
                                  '@frontend/views/category/_product_item',
                                  [
                                      'product' => $model,
                                  ]
                              );
                          },
                      ]
                  );
                  echo Html::tag(
                      'div',
                      LinkPager::widget(
                          [
                              'pagination' => $dataProvider->pagination,
                          ]
                      ),
                      [
                          'class' => 'pages',
                      ]
                  );
              } else {
                  echo \Yii::t('app', 'Введите текст для поиска в строке выше.');
              }
          ?>
      </div>
    </div>
  </div>
</div>