<?php
    use artbox\core\components\SeoComponent;
    use artbox\core\models\Page;
    use yii\helpers\Html;
    use yii\web\View;
    
    /**
     * @var View         $this
     * @var Page         $model
     * @var Page[]       $pages
     * @var SeoComponent $seo
     */
    $seo = \Yii::$app->get('seo');
    $this->params[ 'breadcrumbs' ][] = $seo->title;
?>

<div id="content">
    <div class="container">
        
        <div class="row">
            
            <!-- *** LEFT COLUMN ***
      _________________________________________________________ -->
            
            <div class="col-md-9 clearfix">
                <section>
                    <div id="text-page">
                        
                        <?= $model->lang->body ?>
                    
                    </div>
                </section>
            
            </div>
            <!-- /.col-md-9 -->
            
            <!-- *** LEFT COLUMN END *** -->
            
            <!-- *** RIGHT COLUMN ***
        _________________________________________________________ -->
            
            <div class="col-sm-3">
                <!-- *** PAGES MENU ***
        _________________________________________________________ -->
                <div class="panel panel-default sidebar-menu">
                    
                    <div class="panel-heading">
                        <h3 class="panel-title">Страницы</h3>
                    </div>
                    
                    <div class="panel-body">
                        <ul class="nav nav-pills nav-stacked">
                            <?php
                                foreach ($pages as $page) {
                                    echo Html::tag(
                                        'li',
                                        Html::a(
                                            $page->lang->title,
                                            [
                                                'page/view',
                                                'id' => $page->id,
                                            ]
                                        )
                                    );
                                }
                            ?>
                        </ul>
                    
                    </div>
                </div>
                
                <!-- *** PAGES MENU END *** -->
                
                
                <div class="banner">
                    <a href="shop-category.html">
                        <img src="/img/banner.jpg" alt="sales 2014" class="img-responsive">
                    </a>
                </div>
                <!-- /.banner -->
            </div>
            <!-- /.col-md-3 -->
            
            <!-- *** RIGHT COLUMN END *** -->
        
        
        </div>
        <!-- /.row -->
    
    </div>
    <!-- /.container -->
</div>
<!-- /#content -->
