<?php
    /**
     * @var View         $this
     * @var string       $content
     * @var SeoComponent $seo
     * @var User         $user
     */
    use artbox\core\components\SeoComponent;
    use artbox\core\models\Feedback;
    use artbox\core\models\Image;
    use artbox\core\models\Page;
    use artbox\core\models\User;
    use artbox\order\models\LoginForm;
    use common\models\Newsletter;
    use common\models\SearchForm;
    use common\models\Settings;
    use frontend\assets\AppAsset;
    use frontend\widgets\LangLink;
    use nodge\eauth\Widget;
    use yii\base\Model;
    use yii\bootstrap\ActiveForm;
    use yii\bootstrap\Html;
    use yii\helpers\Url;
    use yii\web\View;
    use yii\widgets\Breadcrumbs;
    
    AppAsset::register($this);
    /**
     * @var \artbox\order\models\Customer $user
     */
    $user = \Yii::$app->user->identity;
    $seo = Yii::$app->get('seo');
    $feedback = new Feedback();
    $settings = Settings::getInstance();
    $controller = Yii::$app->controller;
    $default_controller = Yii::$app->defaultRoute;
    /**
     * @var LoginForm $loginForm
     */
    $loginForm = \Yii::createObject(
        [
            'class'     => LoginForm::className(),
            'returnUrl' => \Yii::$app->request->absoluteUrl,
        ]
    );
    /**
     * @var Newsletter $newsletter
     */
    $newsletter = \Yii::createObject(
        [
            'class' => Newsletter::className(),
        ]
    );
    $isHome = ( ( $controller->id === $default_controller ) && ( $controller->action->id === $controller->defaultAction ) ) ? true : false;
    /**
     * @var Page[] $pages
     */
    $pages = Page::find()
                 ->where([ 'in_menu' => true ])
                 ->with('lang.alias')
                 ->orderBy(
                     [
                         'sort' => SORT_ASC,
                         'id'   => SORT_ASC,
                     ]
                 )
                 ->all();
    $logo = null;
    if ($settings->logo) {
        $logo_img = Image::findOne($settings->logo);
        if ($logo_img) {
            $logo = $logo_img->getUrl() ?? $logo;
        }
    }
    
    $this->registerMetaTag(
        [
            'name'    => 'description',
            'content' => $seo->desc,
        ]
    )
?>

<?php $this->beginPage() ?>
  
  <!DOCTYPE html>
  <html lang="<?= \Yii::$app->language ?>">
    <head>
      <meta charset="<?= \Yii::$app->charset ?>">
      <meta name="viewport" content="width=device-width, initial-scale=1">
        <?= Html::csrfMetaTags() ?>
      <title><?= Html::encode($seo->title) ?></title>
        <?php $this->head() ?>
    </head>
    <body>
        <?php $this->beginBody() ?>
      <!-- Google Analytics -->
      <script>
          (function(i, s, o, g, r, a, m) {
              i[ 'GoogleAnalyticsObject' ] = r;
              i[ r ] = i[ r ] || function() {
                      (i[ r ].q = i[ r ].q || []).push(arguments)
                  }, i[ r ].l = 1 * new Date();
              a = s.createElement(o), m = s.getElementsByTagName(o)[ 0 ];
              a.async = 1;
              a.src = g;
              m.parentNode.insertBefore(a, m)
          })(window, document, 'script', 'https://www.google-analytics.com/analytics.js', 'ga');

          ga('create', <?=$settings->ga_code?>, 'auto');
          ga('send', 'pageview');
      
      </script>
      <div id="all">
        <header>
          
          <!-- *** TOP ***
_________________________________________________________ -->
          <div id="top" class="hidden-sm hidden-xs">
            <div class="container">
              <div class="row">
                <div class="col-xs-6 left-top-nav">
                    <?php
                        foreach ($pages as $page) {
                            echo Html::a(
                                $page->lang->title,
                                [
                                    'page/view',
                                    'id' => $page->id,
                                ]
                            );
                        }
                        echo Html::a(
                            \Yii::t('app', 'Контакты'),
                            [
                                'site/contact',
                            ]
                        );
                    ?>
                </div>
                <div class="col-xs-6 right-top-nav">
                  <div class="inline-block lang-link">
                      <?php
                          echo LangLink::widget();
                      ?>
                  </div>
                  <div class="inline-block">
                    <span class="top-phone"><i class="fa fa-phone"></i>&ensp;<?php echo $settings->phone; ?></span>
                    <a href="#" data-toggle="modal" data-target="#callback-modal" class="link-underline_dott">
                        <?php echo "Обратный звонок"; ?>
                    </a>
                  </div>
                  <div class="inline-block login">
                      <?php
                          if (\Yii::$app->user->isGuest) {
                              ?>
                            <a href="#" data-toggle="modal" data-target="#login-modal"><i class="fa fa-sign-in"></i>
                              <span>Вход</span></a>
                              <?php
                          } else {
                              echo Html::a($user->username, [ 'account/index' ]);
                          }
                      ?>
                  </div>
                </div>
              </div>
            </div>
          </div>
          
          <!-- *** TOP END *** -->
          
          <!-- *** NAVBAR ***
  _________________________________________________________ -->
          
          <div class="navbar-affixed-top" data-spy="affix" data-offset-top="200">
            
            <div class="navbar navbar-default yamm" role="navigation" id="navbar">
              
              <div class="container">
                <div class="navbar-header">
                    <?php
                        echo Html::a(
                            Html::img(
                                $logo ? : '/img/no-image.png',
                                [
                                    'alt' => 'logo',
                                ]
                            ),
                            '/ru/',
                            [
                                'class' => 'navbar-brand home',
                            ]
                        )
                    ?>
                  <div class="navbar-buttons">
                    <button type="button" class="navbar-toggle btn-template-main" data-toggle="collapse" data-target="#navigation">
                                            <span class="sr-only"><?php echo \Yii::t(
                                                    'app',
                                                    'Toggle navigation'
                                                ); ?></span>
                      <i class="fa fa-align-justify"></i>
                    </button>
                  </div>
                </div>
                <!--/.navbar-header -->
                
                <div class="navbar-collapse collapse navbar-left" id="navigation">
                  <ul class="nav navbar-nav navbar-left">
                    <li class="main-nav-item active">
                      <a href="#home-category-anchor" <?php echo $isHome ? '' : 'role="button" class="dropdown-toggle" data-toggle="dropdown" data-hover="dropdown" data-delay="200"'; ?>><span class="btn-like"><?php echo \Yii::t(
                                  'app',
                                  'Каталог'
                              ); ?><i class="fa fa-bars" aria-hidden="true"></i></span></a>
                        <?php
                            if (!$isHome) {
                                echo $this->render(
                                    '_category_menu',
                                    [
                                        'isHome' => $isHome,
                                    ]
                                );
                            }
                        ?>
                    </li>
                    <li class="main-nav-item">
                        <?php
                            echo Html::a(
                                \Yii::t('app', 'Акции'),
                                [
                                    '/special/index',
                                    'type' => 'sale',
                                ]
                            );
                        ?>
                    </li>
                    <li class="main-nav-item">
                        <?php
                            echo Html::a(
                                \Yii::t('app', 'Новинки'),
                                [
                                    '/special/index',
                                    'type' => 'new',
                                ]
                            );
                        ?>
                    </li>
                    <li class="main-nav-item">
                        <?php
                            echo Html::a(
                                \Yii::t('app', 'Блог'),
                                [
                                    '/blog/index',
                                ]
                            );
                        ?>
                    </li>
                  </ul>
                </div>
                <!--/.nav-collapse -->
  
                <div class="cart-item" id="cart">
                  <span class="badge">0</span>
                    <?php
                        echo Html::a(
                            Html::tag(
                                'span',
                                \Yii::t('app', 'Корзина'),
                                [
                                    'class' => 'sub-title',
                                ]
                            ),
                            [
                                '#',
                            ],
                            [
                                'class'       => 'cart-item-link',
                                'data-toggle' => 'modal',
                                'data-target' => '#basket-modal',
                            ]
                        );
                    ?>
                </div>
                
                <div class="search-block" id="search">
                    <?php
                        /**
                         * @var Model $search
                         */
                        $search = \Yii::createObject(SearchForm::className());
                        $searchForm = ActiveForm::begin(
                            [
                                'action'  => [ '/search/index' ],
                                'id'      => 'search-form',
                                'method'  => 'get',
                                'options' => [
                                    'class' => 'navbar-form',
                                    'role'  => 'search',
                                ],
                            ]
                        );
                        echo Html::beginTag(
                            'div',
                            [
                                'class' => 'input-group',
                            ]
                        );
                        echo $searchForm->field(
                            $search,
                            'word',
                            [
                                'options' => [
                                    'tag' => false,
                                ],
                            ]
                        )
                                        ->label(false)
                                        ->textInput(
                                            [
                                                'placeholder' => $search->getAttributeLabel('word'),
                                                'name'        => 'word',
                                            ]
                                        );
                        echo Html::tag(
                            'span',
                            Html::submitButton(
                                Html::tag(
                                    'i',
                                    '',
                                    [
                                        'class' => 'fa fa-search',
                                    ]
                                ),
                                [
                                    'class' => 'btn btn-template-main',
                                ]
                            ),
                            [
                                'class' => 'input-group-btn',
                            ]
                        );
                        echo Html::endTag('div');
                        $searchForm::end();
                    ?>
                </div>
                
                
                <!--/.nav-collapse -->
              </div>
            </div>
            <!-- /#navbar -->
          </div>
          <!-- *** NAVBAR END *** -->
        </header>
        
        <!-- *** LOGIN MODAL ***
_________________________________________________________ -->
          <?php
              if (\Yii::$app->user->isGuest) {
                  ?>
                <div class="modal fade" id="login-modal" tabindex="-1" role="dialog" aria-labelledby="Login" aria-hidden="true">
                  <div class="modal-dialog modal-sm">
  
                    <div class="modal-content">
                      <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title text-center" id="Login">
                            <?php echo \Yii::t('app', 'Customer login'); ?>
                        </h4>
                      </div>
                      <div class="modal-body">
                          <?php
                              if (\Yii::$app->get('eauth', false)) {
                                  echo Html::tag(
                                      'p',
                                      \Yii::t(
                                          'app',
                                          'Do you already have an account on one of these sites? Click the logo to log in with it here'
                                      ) . ':',
                                      [
                                          'class' => 'lead',
                                      ]
                                  );
                                  echo Widget::widget([ 'action' => 'site/login' ]);
                              }
                              $login = ActiveForm::begin(
                                  [
                                      'action' => [ '/site/login' ],
                                  ]
                              );
                              echo $login->field($loginForm, 'returnUrl')
                                         ->label(false)
                                         ->hiddenInput();
                              echo $login->field($loginForm, 'username')
                                         ->label(false)
                                         ->textInput(
                                             [
                                                 'placeholder' => $loginForm->getAttributeLabel('username'),
                                             ]
                                         );
                              echo $login->field($loginForm, 'password')
                                         ->label(false)
                                         ->passwordInput(
                                             [
                                                 'placeholder' => $loginForm->getAttributeLabel('пароль'),
                                             ]
                                         );
                              echo $login->field($loginForm, 'rememberMe')
                                         ->checkbox();
                          ?>
                        <div class="text-center">
                            <?php
                                echo Html::submitButton(
                                    \Yii::t('app', 'Login'),
                                    [
                                        'class' => 'btn btn-success',
                                    ]
                                );
                                $login::end();
                            ?>
                        </div>
                        <p class="text-center text-muted">
                            <?php echo \Yii::t('app', 'Not registered yet?'); ?></p>
                        <p class="text-center text-muted">
                            <?php
                                echo Html::a(
                                    Html::tag('strong', \Yii::t('app', 'Register now!')),
                                    [
                                        '/site/login',
                                    ]
                                );
                            ?>
                        </p>

                      </div>
                    </div>
                  </div>
                </div>
                  <?php
              }
          ?>
        
        <!-- *** LOGIN MODAL END *** -->
  
  
        <!-- *** SUCCESS MODAL BEGIN ***
_________________________________________________________ -->
          <?php
              if ($msg = \Yii::$app->session->getFlash('success')) {
                  ?>
                <div class="modal fade" id="success-modal" tabindex="-1" role="dialog" aria-labelledby="Success" aria-hidden="true">
                  <div class="modal-dialog modal-sm">
  
                    <div class="modal-content">
                      <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                      </div>
                      <div class="modal-body">
                          <?php echo $msg; ?>
                      </div>
                    </div>
                  </div>
                </div>
                  <?php
                  $this->registerJs("$('#success-modal').modal('show');");
              }
          ?>
        
        <!-- *** Breadcrumbs *** -->
        <!-- *** FEEDBACK MODAL BEGIN *** -->
          <?php
          ?>
    
          <?php
              $callback = new Feedback(
                  [
                      'scenario'  => Feedback::SCENARIO_CALLBACK,
                      'returnUrl' => Url::current([], true),
                  ]
              );
          ?>
        <div class="modal fade" id="callback-modal" tabindex="-1" role="dialog" aria-labelledby="Login" aria-hidden="true">
          <div class="modal-dialog modal-sm">
  
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title callback text-center" id="Login">Обратный звонок</h4>
              </div>
              <div class="modal-body">
                  <?php
                      $form = ActiveForm::begin(
                          [
                              'action' => [ 'site/callback' ],
                          ]
                      );
                      echo $form->field($callback, 'returnUrl')
                                ->label(false)
                                ->hiddenInput();
                      echo $form->field($callback, 'name')
                                ->label(false)
                                ->textInput(
                                    [
                                        'placeholder' => $callback->getAttributeLabel('Ваше имя'),
                                    ]
                                );
                      echo $form->field($callback, 'phone')
                                ->label(false)
                                ->textInput(
                                    [
                                        'placeholder' => $callback->getAttributeLabel('Номер телефона'),
                                    ]
                                );
                      echo Html::tag(
                          'p',
                          Html::submitButton(
                              Html::icon(
                                  'sign-in',
                                  [
                                      'prefix' => 'fa fa-',
                                  ]
                              ) . \Yii::t('app', 'Отправить'),
                              [
                                  'class' => 'btn btn-template-main',
                              ]
                          ),
                          [
                              'class' => 'text-center',
                          ]
                      );
                      $form::end();
                  ?>
              </div>
            </div>
          </div>
        </div>
        <!-- *** FEEDBACK MODAL END *** -->
  
        <!-- *** MODAL BASKET START *** -->
  
        <div class="modal fade" id="basket-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <?php
                echo $this->render('_basket_modal');
            ?>
        </div>
        <!-- *** MODAL BASKET END *** -->
          <?php
              if (!$isHome) {
                  ?>
                <div id="heading-breadcrumbs">
                  <div class="container">
                      <?= Breadcrumbs::widget(
                          [
                              'links'    => isset($this->params[ 'breadcrumbs' ]) ? $this->params[ 'breadcrumbs' ] : [],
                              'homeLink' => [
                                  'label' => \Yii::t('app', 'Home'),
                                  'url'   => [ '/site/index' ],
                              ],
                          ]
                      ) ?>
                  </div>
                </div>
                  <?php
              }
          ?>
        <!-- *** crumbs END *** -->
          
          <?= $content ?>
        
        <!-- *** FOOTER ***
_________________________________________________________ -->
        
        <footer id="footer">
          <div class="container">
            <div class="col-md-3 col-sm-6">
              <h4>О нас</h4>
  
              <p><?= $settings->about ?></p>
              
              <hr class="hidden-md hidden-lg hidden-sm">
            
            </div>
            <!-- /.col-md-3 -->
  
            <div class="col-md-3 col-sm-6">
    
              <h4>Разделы</h4>
              
              <div class="blog-entries">
    
                  <?php foreach ($pages as $page) { ?>
                    <div class="item same-height-row clearfix">
                      <div class="name">
                        <h5><?= Html::a(
                                $page->lang->title,
                                [
                                    'page/view',
                                    'id' => $page->id,
                                ]
                            ) ?></h5>
                      </div>
                    </div>
                  <?php } ?>
                
                <div class="item same-height-row clearfix">
                  <div class="name">
                    <h5><?= Html::a(\Yii::t('app', 'Контакты'), [ 'site/contact' ]) ?></h5>
                  </div>
                </div>

              </div>
              
              <hr class="hidden-md hidden-lg">
            
            </div>
            
            <div class="col-md-3 col-sm-6">
  
              <h4>Социальные сети</h4>
  
              <p class="socials-links">
                  <?php if (!empty($settings->facebook)) { ?>
                    <a href="<?= $settings->facebook ?>"><i class="fa fa-facebook-official" aria-hidden="true"></i></a>
                  <?php }
                      if (!empty($settings->vk)) { ?>
                        <a href="<?= $settings->vk ?>"><i class="fa fa-vk" aria-hidden="true"></i></a>
                      <?php }
                      if (!empty($settings->google)) { ?>
                        <a href="<?= $settings->google ?>"><i class="fa fa-google-plus-square" aria-hidden="true"></i></a>
                      <?php }
                      if (!empty($settings->twitter)) { ?>
                        <a href="<?= $settings->twitter ?>"><i class="fa fa-twitter-square" aria-hidden="true"></i></a>
                      <?php }
                      if (!empty($settings->ok)) { ?>
                        <a href="<?= $settings->ok ?>"><i class="fa fa-odnoklassniki" aria-hidden="true"></i></a>
                      <?php } ?>
              </p>
            
            </div>
            
            <div class="col-md-3 col-sm-6">
  
              <h4>Контактная информация</h4>
  
              <p><strong><?= $settings->email ?></strong>
                <br><?= $settings->city . ',' ?>
                <br><?= $settings->street . ', ' . $settings->house ?>
                <br>
                <strong><?= $settings->country ?></strong>
              </p>
                <?php
                    echo Html::a(
                        \Yii::t('app', 'Написать нам'),
                        [ 'site/contact' ],
                        [
                            'class' => 'btn btn-small btn-template-main',
                        ]
                    );
                ?>
              
              <hr class="hidden-md hidden-lg hidden-sm">
            
            </div>
            <!-- /.col-md-3 -->
          </div>
          <!-- /.container -->
        </footer>
        <!-- /#footer -->
        
        <!-- *** FOOTER END *** -->


      </div>
      <!-- /#all -->
        <?php $this->endBody() ?>
    </body>
  </html>
<?php $this->endPage() ?>