<?php
    use artbox\catalog\models\Category;
    use yii\bootstrap\Html;
    use yii\web\View;
    
    /**
     * @var View $this
     * @var bool $isHome
     */
    $categories = Category::find()
                          ->with('categories.lang.alias', 'lang.alias')
                          ->where([ 'level' => 0 ])
                          ->all();
?>
<ul class="dropdown-menu <?php echo $isHome ? 'sidebar' : 'multi-level'; ?>" role="menu" aria-labelledby="dLabel" <?php echo $isHome ? 'id="home-category-anchor"' : ''; ?>>
    <?php
        foreach ($categories as $category) {
            if ($category->lang->alias) {
                ?>
              <li class="dropdown-submenu">
                  <?php
                      echo Html::a(
                          $category->lang->title,
                          [
                              'category/view',
                              'category' => $category->lang->alias->value,
                          ],
                          [
                              'tabindex' => -1,
                          ]
                      );
                      if (!empty($category->categories)) {
                          ?>
                        <ul class="dropdown-menu">
                            <?php
                                foreach ($category->categories as $childCategory) {
                                    if ($childCategory->lang->alias) {
                                        echo Html::tag(
                                            'li',
                                            Html::a(
                                                $childCategory->lang->title,
                                                [
                                                    'category/view',
                                                    'category' => $childCategory->lang->alias->value,
                                                ]
                                            )
                                        );
                                    }
                                }
                            ?>
                        </ul>
                          <?php
                      }
                  ?>
              </li>
                <?php
            }
        }
    ?>
</ul>
