<div class="modal-dialog modal-lg">
  <div class="modal-content">
    <div class="modal-header">
      <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
      <h4 class="modal-title callback text-center" id="Login">
          <?php
              use artbox\core\helpers\ImageHelper;
              use frontend\models\ShareBasket;
              use yii\bootstrap\ActiveForm;
              use yii\bootstrap\Html;
              
              echo Html::a(
                  Html::tag(
                      'span',
                      \Yii::t('app', 'Ваша корзина')
                  ),
                  [
                      '/checkout/index',
                  ]
              );
          ?>
      </h4>
    </div>
    <div class="modal-body">
        <?php
            /**
             * @var \artbox\order\models\Basket $basket
             */
            $basket = \Yii::$app->get('basket');
            $data = $basket->getData();
            $variants = [];
            if (!empty($data)) {
                $variants = $basket->findModels(array_keys($data));
            }
            $formatter = \Yii::$app->formatter;
            $sum = 0;
            $sumDiscount = 0;
            foreach ($basket->findModels(array_keys($basket->getData())) as $variant) {
                $count = $basket->getItem($variant->id)[ 'count' ];
                $sum += $variant->price * $count;
                if (!empty($variant->price_old)) {
                    $sumDiscount += ( $variant->price_old - $variant->price ) * $count;
                }
            }
            
            if (!empty($variants)) {
                ?>
              <div class="clearfix">
                <div class="col-md-12 clearfix">
                  <table class="table">
                    <thead>
                      <tr>
                        <th colspan="2"><?php echo \Yii::t('app', 'Продукт'); ?></th>
                        <th><?php echo \Yii::t('app', 'Количество'); ?></th>
                        <th><?php echo \Yii::t('app', 'Цена за единицу'); ?></th>
                        <th><?php echo \Yii::t('app', 'Скидка'); ?></th>
                        <th colspan="2"><?php echo \Yii::t('app', 'Всего'); ?></th>
                      </tr>
                    </thead>
                    <tbody>
                        <?php
                            foreach ($variants as $variant) {
                                $count = $basket->getItem($variant->id)[ 'count' ];
                                ?>
                              <tr data-id="<?php echo $variant->id; ?>" class="product-row-basket">
                                <td>
                                    <?php
                                        echo Html::a(
                                            ImageHelper::set(
                                                $variant->product->image ? $variant->product->image->getPath(
                                                ) : '@frontend/img/no-image.png'
                                            )
                                                       ->fillResize(50, 50)
                                                       ->renderImage(
                                                           [
                                                               'alt'   => $variant->product->lang->title,
                                                               'title' => $variant->product->lang->title,
                                                           ]
                                                       ),
                                            [
                                                '/product/view',
                                                'id' => $variant->product->id,
                                            ],
                                            [
                                                'target' => '_blank',
                                            ]
                                        );
                                    ?>
                                </td>
                                <td>
                                    <?php
                                        echo Html::a(
                                            $variant->product->lang->title,
                                            [
                                                '/product/view',
                                                'id' => $variant->product->id,
                                            ],
                                            [
                                                'target' => '_blank',
                                            ]
                                        );
                                    ?>
                                </td>
                                <td>
                                    <?php
                                        echo Html::input(
                                            'number',
                                            '',
                                            $count,
                                            [
                                                'class' => 'form-control increase-product-basket',
                                            ]
                                        );
                                    ?>
                                </td>
                                <td>
                                    <?php
                                        echo $formatter->asDecimal($variant->price ? : 0, 2);
                                    ?>
                                </td>
                                <td>
                                    <?php
                                        if (!empty($variant->price_old)) {
                                            echo $formatter->asDecimal($variant->price_old - $variant->price, 2);
                                        } else {
                                            echo $formatter->asDecimal(0, 2);
                                        }
                                    ?>
                                </td>
                                <td>
                                    <?php
                                        echo $formatter->asDecimal(
                                            ( $variant->price ? : 0 ) * $count,
                                            2
                                        );
                                    ?>
                                </td>
                                <td><a href="#" class="remove-product-cart"><i class="fa fa-trash-o"></i></a>
                                </td>
                              </tr>
                                <?php
                            }
                        ?>
                    </tbody>
                    <tfoot>
                      <tr>
                        <th colspan="5"><?php echo \Yii::t('app', 'Всего'); ?></th>
                        <th colspan="2"><?php echo $formatter->asDecimal($sum, 2); ?></th>
                      </tr>
                    </tfoot>
                  </table>
                </div>
                <div class="col-md-12 clearfix">
                  <div class="box" id="order-summary">
                    <div class="box-header">
                      <h3>Итоговый счет</h3>
                    </div>
                    <p class="text-muted small"><?php echo \Yii::t(
                            'app',
                            'Стоимость доставки рассчитывается в зависимости от адреса и способа доставки'
                        ); ?></p>
                    
                    <div class="table-responsive">
                      <table class="table">
                        <tbody>
                          <tr>
                            <td><?php echo \Yii::t('app', 'Всего за товары'); ?></td>
                            <th><?php echo $formatter->asDecimal($sum, 2); ?></th>
                          </tr>
                          <tr>
                            <td><?php echo \Yii::t('app', 'Сумма скидки'); ?></td>
                            <th><?php echo $formatter->asDecimal($sumDiscount, 2); ?></th>
                          </tr>
                          <tr class="total">
                            <td><?php echo \Yii::t('app', 'Итого к оплате'); ?></td>
                            <th><?php echo $formatter->asDecimal($sum, 2); ?></th>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
                <div class="col-md-12 clearfix">
                  
                  <div class="box">
                    
                    <div class="table-responsive">
                    
                    
                    </div>
                    <!-- /.table-responsive -->
                    
                    <div class="box-footer">
                      <div class="col-xs-12 col-sm-9">
                          <?php
                              $shareBasket = new ShareBasket();
                              $shareBasketForm = ActiveForm::begin(
                                  [
                                      'action'  => [ '/site/share-basket' ],
                                      'options' => [
                                          'class' => 'share-basket-form',
                                          'data'  => [
                                              'title' => \Yii::t('app', 'Shared basket'),
                                              'msg'   => \Yii::t('app', 'Basket successfully shared.'),
                                          ],
                                      ],
                                  ]
                              );
                          ?>
                        <div class="col-xs-12 col-sm-4">
                            <?php
                                echo Html::label(
                                    $shareBasket->getAttributeLabel('email'),
                                    Html::getInputId($shareBasket, 'email')
                                );
                            ?>
                        </div>
                        <div class="col-xs-12 col-sm-6">
                            <?php
                                echo $shareBasketForm->field($shareBasket, 'email')
                                                     ->textInput(
                                                         [
                                                             'placeholder' => 'email@email.com',
                                                         ]
                                                     )
                                                     ->label(false);
                            ?>
                        </div>
                        <div class="col-xs-12 col-sm-2">
                            <?php
                                echo Html::submitButton(
                                    \Yii::t('app', 'Ok'),
                                    [
                                        'class' => 'btn btn-primary',
                                    ]
                                );
                            ?>
                        </div>
                          <?php
                              $shareBasketForm::end();
                          ?>
                      </div>
                      <div class="pull-right">
                          <?php
                              echo Html::a(
                                  \Yii::t(
                                      'app',
                                      ' Оформить заказ '
                                  ) . Html::icon('chevron-right', [ 'prefix' => 'fa fa-' ]),
                                  [ 'checkout/info' ],
                                  [
                                      'class' => 'btn btn-success',
                                  ]
                              )
                          ?>
                      </div>
                    </div>
                  </div>
                
                </div>
              </div>
                <?php
            } else {
                echo Html::tag('p', \Yii::t('app', 'Ваша корзина пуста!'));
            }
        ?>
    </div>
  </div>
</div>
