<?php
    use artbox\catalog\helpers\FilterHelper;
    use artbox\catalog\models\Brand;
    use artbox\catalog\models\Category;
    use artbox\catalog\models\Product;
    use yii\bootstrap\Html;
    use yii\data\ActiveDataProvider;
    
    /**
     * @var ActiveDataProvider $dataProvider
     * @var Category           $category
     * @var FilterHelper       $filterHelper
     */
    $filterHelper = \Yii::$app->get('filter');
?>
<div class="row">
    <div class="col-xs-6">
        <div class="panel">
            <div class="panel-heading">
                <h3>Brand</h3>
            </div>
            <div class="panel-body">
                <div class="form-group">
                    <?php
                        foreach ($filterHelper->getBrands($category) as $brand) {
                            /**
                             * @var Product $product
                             * @var Brand   $brand
                             */
                            echo Html::tag(
                                'div',
                                Html::tag(
                                    'label',
                                    $brand->lang->title . ': ' . Html::a(
                                        $filterHelper->buildLink($brand),
                                        [
                                            '/filter/index',
                                            'filter'      => $filterHelper->buildLink($brand),
                                            'category_id' => $category->id,
                                        ]
                                    )
                                ),
                                [
                                    'class' => 'checkbox',
                                ]
                            );
                        }
                    ?>
                </div>
            </div>
        </div>
        <?php
            foreach ($category->productOptionGroupCompls as $group) {
                ?>
                <div class="panel">
                    <div class="panel-heading">
                        <h3><?php echo $group->lang->title; ?></h3>
                    </div>
                    <div class="panel-body">
                        <div class="form-group">
                            <?php
                                foreach ($group->options as $option) {
                                    /**
                                     * @var Product $product
                                     */
                                    echo Html::tag(
                                        'div',
                                        Html::tag(
                                            'label',
                                            $option->lang->value . ': ' . $filterHelper->buildLink($option)
                                        ),
                                        [
                                            'class' => 'checkbox',
                                        ]
                                    );
                                }
                            ?>
                        </div>
                    </div>
                </div>
                <?php
            }
            foreach ($category->productOptionGroupExcls as $group) {
                ?>
                <div class="panel">
                    <div class="panel-heading">
                        <h3><?php echo $group->lang->title; ?></h3>
                    </div>
                    <div class="panel-body">
                        <div class="form-group">
                            <?php
                                foreach ($group->options as $option) {
                                    /**
                                     * @var Product $product
                                     */
                                    echo Html::tag(
                                        'div',
                                        Html::tag(
                                            'label',
                                            $option->lang->value . ': ' . $filterHelper->buildLink($option)
                                        ),
                                        [
                                            'class' => 'checkbox',
                                        ]
                                    );
                                }
                            ?>
                        </div>
                    </div>
                </div>
                <?php
            }
            foreach ($category->variantOptionGroupCompls as $group) {
                ?>
                <div class="panel">
                    <div class="panel-heading">
                        <h3><?php echo $group->lang->title; ?></h3>
                    </div>
                    <div class="panel-body">
                        <div class="form-group">
                            <?php
                                foreach ($group->options as $option) {
                                    /**
                                     * @var Product $product
                                     */
                                    echo Html::tag(
                                        'div',
                                        Html::tag(
                                            'label',
                                            $option->lang->value . ': ' . $filterHelper->buildLink($option)
                                        ),
                                        [
                                            'class' => 'checkbox',
                                        ]
                                    );
                                }
                            ?>
                        </div>
                    </div>
                </div>
                <?php
            }
            foreach ($category->variantOptionGroupExcls as $group) {
                ?>
                <div class="panel">
                    <div class="panel-heading">
                        <h3><?php echo $group->lang->title; ?></h3>
                    </div>
                    <div class="panel-body">
                        <div class="form-group">
                            <?php
                                foreach ($group->options as $option) {
                                    /**
                                     * @var Product $product
                                     */
                                    echo Html::tag(
                                        'div',
                                        Html::tag(
                                            'label',
                                            $option->lang->value . ': ' . $filterHelper->buildLink($option)
                                        ),
                                        [
                                            'class' => 'checkbox',
                                        ]
                                    );
                                }
                            ?>
                        </div>
                    </div>
                </div>
                <?php
            }
        ?>
    </div>
    <div class="col-xs-6">
        <?php
            foreach ($dataProvider->getModels() as $model) {
                /**
                 * @var Product $model
                 */
                echo $model->lang->title . "<br>";
            }
        ?>
    </div>
</div>