<?php
    /**
     * @var \yii\web\View                  $this
     * @var \frontend\models\Order         $model
     * @var \artbox\order\models\Payment[] $payments
     * @var \artbox\order\models\Basket    $basket
     */
    use yii\bootstrap\ActiveForm;
    use yii\bootstrap\Html;
    
    $formatter = \Yii::$app->formatter;
    $basket = \Yii::$app->get('basket');
    $sum = 0;
    $sumDiscount = 0;
    foreach ($basket->findModels(array_keys($basket->getData())) as $variant) {
        $count = $basket->getItem($variant->id)[ 'count' ];
        $sum += $variant->price * $count;
        if (!empty($variant->price_old)) {
            $sumDiscount += ( $variant->price_old - $variant->price ) * $count;
        }
    }
?>
<div id="content">
  <div class="container">
    
    <div class="row">
      
      <div class="col-md-9 clearfix" id="checkout">
        
        <div class="box">
            <?php
                $form = ActiveForm::begin();
            ?>
          <ul class="nav nav-pills nav-justified">
              <?php
                  echo Html::tag(
                      'li',
                      Html::a(
                          Html::icon(
                              'map-marker',
                              [
                                  'prefix' => 'fa fa-',
                              ]
                          ) . Html::tag('br') . \Yii::t('app', 'Адрес'),
                          [ 'checkout/info' ]
                      )
                  );
                  echo Html::tag(
                      'li',
                      Html::a(
                          Html::icon(
                              'truck',
                              [
                                  'prefix' => 'fa fa-',
                              ]
                          ) . Html::tag('br') . \Yii::t('app', 'Способ доставки'),
                          [ 'checkout/delivery' ]
                      )
                  );
                  echo Html::tag(
                      'li',
                      Html::a(
                          Html::icon(
                              'money',
                              [
                                  'prefix' => 'fa fa-',
                              ]
                          ) . Html::tag('br') . \Yii::t('app', 'Способ оплаты'),
                          [
                              '#',
                          ]
                      ),
                      [
                          'class' => 'active',
                      ]
                  );
                  echo Html::tag(
                      'li',
                      Html::a(
                          Html::icon(
                              'eye',
                              [
                                  'prefix' => 'fa fa-',
                              ]
                          ) . Html::tag('br') . \Yii::t('app', 'Просмотр заказа'),
                          [
                              'checkout/confirm',
                          ]
                      ),
                      [
                          'class' => 'disabled',
                      ]
                  );
              ?>
          </ul>
          
          
          <div class="content">
            <div class="row">
                <?php
                    if ($model->hasErrors()) {
                        echo Html::tag(
                            'p',
                            \Yii::t('app', 'Please choose payment method.'),
                            [
                                'class' => 'text-danger',
                            ]
                        );
                    }
                    foreach ($payments as $index => $payment) {
                        ?>
                      <div class="col-sm-4">
                        <div class="box shipping-method">
                          
                          <div class="box-header text-center">
                              <?php
                                  echo $form->field(
                                      $model,
                                      'payment_id',
                                      [
                                          'options' => [
                                              'class' => 'form-group order-radio',
                                          ],
                                      ]
                                  )
                                            ->radio(
                                                [
                                                    'uncheck' => ( $index === 0 ) ? 0 : null,
                                                    'label'   => null,
                                                    'tag'     => false,
                                                    'value'   => $payment->id,
                                                ]
                                            )
                                            ->label(false)
                                            ->error(false);
                              ?>
                            <h4><?php echo $payment->lang->title; ?></h4>
                          </div>
                          
                          <p><?php echo $payment->lang->description; ?></p>
                        
                        </div>
                      </div>
                        <?php
                    }
                ?>
            </div>
            <!-- /.row -->
          
          </div>
          <!-- /.content -->
          
          <div class="box-footer">
            <div class="pull-left">
                <?php
                    echo Html::a(
                        Html::icon(
                            'chevron-left',
                            [
                                'prefix' => 'fa fa-',
                            ]
                        ) . \Yii::t('app', 'Доставка'),
                        [
                            'checkout/delivery',
                        ],
                        [
                            'class' => 'btn btn-default',
                        ]
                    );
                ?>
            </div>
            <div class="pull-right">
                <?php
                    echo Html::submitButton(
                        \Yii::t('app', 'Перейти к просмотру заказа') . Html::icon(
                            'chevron-right',
                            [
                                'prefix' => 'fa fa-',
                            ]
                        ),
                        [
                            'class' => 'btn btn-success',
                        ]
                    );
                ?>
            </div>
          </div>
            <?php
                $form::end();
            ?>
        </div>
        <!-- /.box -->
      
      
      </div>
      <!-- /.col-md-9 -->
      
      <div class="col-md-3">
        <div class="box" id="order-summary">
          <div class="box-header">
            <h3>Итоговый счет</h3>
          </div>
          <p class="text-muted small"><?php echo \Yii::t(
                  'app',
                  'Стоимость доставки рассчитывается в зависимости от адреса и способа доставки'
              ); ?></p>
          
          <div class="table-responsive">
            <table class="table">
              <tbody>
                <tr>
                  <td><?php echo \Yii::t('app', 'Всего за товары'); ?></td>
                  <th><?php echo $formatter->asDecimal($sum, 2); ?></th>
                </tr>
                <tr>
                  <td><?php echo \Yii::t('app', 'Сумма скидки'); ?></td>
                  <th><?php echo $formatter->asDecimal($sumDiscount, 2); ?></th>
                </tr>
                <tr class="total">
                  <td><?php echo \Yii::t('app', 'Итого к оплате'); ?></td>
                  <th><?php echo $formatter->asDecimal($sum, 2); ?></th>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
      <!-- /.col-md-3 -->
    
    </div>
    <!-- /.row -->
  
  </div>
  <!-- /.container -->
</div>
