<?php
    /**
     * @var \yii\web\View               $this
     * @var \frontend\models\Order      $model
     * @var \artbox\order\models\Basket $basket
     */
    use yii\bootstrap\ActiveForm;
    use yii\bootstrap\Html;
    
    $formatter = \Yii::$app->formatter;
    $basket = \Yii::$app->get('basket');
    $sum = 0;
    $sumDiscount = 0;
    foreach ($basket->findModels(array_keys($basket->getData())) as $variant) {
        $count = $basket->getItem($variant->id)[ 'count' ];
        $sum += $variant->price * $count;
        if (!empty($variant->price_old)) {
            $sumDiscount += ( $variant->price_old - $variant->price ) * $count;
        }
    }
?>
<div id="content">
  <div class="container">
    
    <div class="row">
      
      <div class="col-md-9 clearfix" id="checkout">
        
        <div class="box">
            <?php
                $form = ActiveForm::begin();
            ?>
          
          <ul class="nav nav-pills nav-justified">
              <?php
                  echo Html::tag(
                      'li',
                      Html::a(
                          Html::icon(
                              'map-marker',
                              [
                                  'prefix' => 'fa fa-',
                              ]
                          ) . Html::tag('br') . \Yii::t('app', 'Адрес'),
                          '#'
                      ),
                      [
                          'class' => 'active',
                      ]
                  );
                  echo Html::tag(
                      'li',
                      Html::a(
                          Html::icon(
                              'truck',
                              [
                                  'prefix' => 'fa fa-',
                              ]
                          ) . Html::tag('br') . \Yii::t('app', 'Способ доставки'),
                          [
                              'checkout/delivery',
                          ]
                      ),
                      [
                          'class' => 'disabled',
                      ]
                  );
                  echo Html::tag(
                      'li',
                      Html::a(
                          Html::icon(
                              'money',
                              [
                                  'prefix' => 'fa fa-',
                              ]
                          ) . Html::tag('br') . \Yii::t('app', 'Способ оплаты'),
                          [
                              'checkout/payment',
                          ]
                      ),
                      [
                          'class' => 'disabled',
                      ]
                  );
                  echo Html::tag(
                      'li',
                      Html::a(
                          Html::icon(
                              'eye',
                              [
                                  'prefix' => 'fa fa-',
                              ]
                          ) . Html::tag('br') . \Yii::t('app', 'Просмотр заказа'),
                          [
                              'checkout/confirm',
                          ]
                      ),
                      [
                          'class' => 'disabled',
                      ]
                  );
              ?>
          </ul>
          
          <div class="content">
              <?php
                  if (\Yii::$app->user->isGuest) {
                      ?>
                    <div class="box-header">
                        <?php
                            echo \Yii::t('app', 'Если вы уже зарегистрированы в нашем магазине');
                        ?>
                      <a href="#" data-toggle="modal" data-target="#login-modal"><span>Войдите в свой аккаунт</span>
                        <i class="fa fa-sign-in"></i></a>
                    </div>
                      <?php
                  }
              ?>
            <div class="row">
              <div class="col-sm-6">
                  <?php
                      echo $form->field($model, 'name')
                                ->textInput();
                  ?>
              </div>
              <div class="col-sm-6"></div>
            </div>
            <!-- /.row -->
            
            <div class="row">
              <div class="col-sm-6">
                  <?php
                      echo $form->field($model, 'city')
                                ->textInput();
                  ?>
              </div>
              <div class="col-sm-6">
                  <?php
                      echo $form->field($model, 'address')
                                ->textInput();
                  ?>
              </div>
            </div>
            <!-- /.row -->
            
            <div class="row">
              <div class="col-sm-6">
                  <?php
                      echo $form->field($model, 'phone')
                                ->textInput();
                  ?>
              </div>
              <div class="col-sm-6">
                  <?php
                      echo $form->field($model, 'email')
                                ->textInput();
                  ?>
              </div>
            </div>
            
            <div class="row">
              <div class="col-xs-12">
                  <?php
                      echo $form->field($model, 'comment')
                                ->textarea(
                                    [
                                        'rows' => 4,
                                    ]
                                );
                  ?>
              </div>
            </div>
            <!-- /.row -->
          </div>
          
          <div class="box-footer">
            <div class="pull-left">
                <?php
                    echo Html::a(
                        Html::icon(
                            'chevron-left',
                            [
                                'prefix' => 'fa fa-',
                            ]
                        ) . \Yii::t('app', 'Назад в корзину'),
                        [
                            'checkout/index',
                        ],
                        [
                            'class' => 'btn btn-default',
                        ]
                    );
                ?>
            </div>
            <div class="pull-right">
                <?php
                    echo Html::submitButton(
                        \Yii::t('app', 'Перейти к выбору способа доставки') . Html::icon(
                            'chevron-right',
                            [
                                'prefix' => 'fa fa-',
                            ]
                        ),
                        [
                            'class' => 'btn btn-success',
                        ]
                    );
                ?>
            </div>
          </div>
            <?php
                $form::end();
            ?>
        </div>
        <!-- /.box -->
      
      
      </div>
      <!-- /.col-md-9 -->
      
      <div class="col-md-3">
        <div class="box" id="order-summary">
          <div class="box-header">
            <h3>Итоговый счет</h3>
          </div>
          <p class="text-muted small"><?php echo \Yii::t(
                  'app',
                  'Стоимость доставки рассчитывается в зависимости от адреса и способа доставки'
              ); ?></p>
          
          <div class="table-responsive">
            <table class="table">
              <tbody>
                <tr>
                  <td><?php echo \Yii::t('app', 'Всего за товары'); ?></td>
                  <th><?php echo $formatter->asDecimal($sum, 2); ?></th>
                </tr>
                <tr>
                  <td><?php echo \Yii::t('app', 'Сумма скидки'); ?></td>
                  <th><?php echo $formatter->asDecimal($sumDiscount, 2); ?></th>
                </tr>
                <tr class="total">
                  <td><?php echo \Yii::t('app', 'Итого к оплате'); ?></td>
                  <th><?php echo $formatter->asDecimal($sum, 2); ?></th>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
      <!-- /.col-md-3 -->
    
    </div>
    <!-- /.row -->
  
  </div>
  <!-- /.container -->
</div>
