<?php
    /**
     * @var \yii\web\View               $this
     * @var \artbox\order\models\Basket $basket
     * @var \frontend\models\Order      $model
     */
    
    use artbox\core\helpers\ImageHelper;
    use yii\bootstrap\ActiveForm;
    use yii\bootstrap\Html;
    
    $formatter = \Yii::$app->formatter;
    $basket = \Yii::$app->get('basket');
    $sum = 0;
    $sumDiscount = 0;
    $variants = $basket->findModels(array_keys($basket->getData()));
    foreach ($variants as $variant) {
        $count = $basket->getItem($variant->id)[ 'count' ];
        $sum += $variant->price * $count;
        if (!empty($variant->price_old)) {
            $sumDiscount += ( $variant->price_old - $variant->price ) * $count;
        }
    }
?>
<div id="content">
  <div class="container">
    
    <div class="row">
      
      <div class="col-md-9 clearfix" id="checkout">
        
        <div class="box">
            <?php
                $form = ActiveForm::begin();
            ?>
          <ul class="nav nav-pills nav-justified">
              <?php
                  echo Html::tag(
                      'li',
                      Html::a(
                          Html::icon(
                              'map-marker',
                              [
                                  'prefix' => 'fa fa-',
                              ]
                          ) . Html::tag('br') . \Yii::t('app', 'Адрес'),
                          [ 'checkout/info' ]
                      )
                  );
                  echo Html::tag(
                      'li',
                      Html::a(
                          Html::icon(
                              'truck',
                              [
                                  'prefix' => 'fa fa-',
                              ]
                          ) . Html::tag('br') . \Yii::t('app', 'Способ доставки'),
                          [ 'checkout/delivery' ]
                      )
                  );
                  echo Html::tag(
                      'li',
                      Html::a(
                          Html::icon(
                              'money',
                              [
                                  'prefix' => 'fa fa-',
                              ]
                          ) . Html::tag('br') . \Yii::t('app', 'Способ оплаты'),
                          [
                              'checkout/payment',
                          ]
                      )
                  );
                  echo Html::tag(
                      'li',
                      Html::a(
                          Html::icon(
                              'eye',
                              [
                                  'prefix' => 'fa fa-',
                              ]
                          ) . Html::tag('br') . \Yii::t('app', 'Просмотр заказа'),
                          '#'
                      ),
                      [
                          'class' => 'active',
                      ]
                  );
              ?>
          </ul>
          
          <div class="content">
            <div class="table-responsive">
              <table class="table">
                <thead>
                  <tr>
                    <th colspan="2"><?php echo \Yii::t('app', 'Product'); ?></th>
                    <th><?php echo \Yii::t('app', 'Quantity'); ?></th>
                    <th><?php echo \Yii::t('app', 'Unit price'); ?></th>
                    <th><?php echo \Yii::t('app', 'Discount'); ?></th>
                    <th><?php echo \Yii::t('app', 'Total'); ?></th>
                  </tr>
                </thead>
                <tbody>
                    <?php
                        foreach ($variants as $variant) {
                            ?>
                          <tr>
                            <td>
                                <?php
                                    echo Html::a(
                                        ImageHelper::set($variant->product->image->getPath())
                                                   ->fillResize(50, 50)
                                                   ->renderImage(
                                                       [
                                                           'alt'   => $variant->product->lang->title,
                                                           'title' => $variant->product->lang->title,
                                                       ]
                                                   ),
                                        [
                                            'product/view',
                                            'id' => $variant->product->id,
                                        ],
                                        [ 'target' => '_blank' ]
                                    )
                                ?>
                            </td>
                            <td>
                                <?php
                                    echo Html::a(
                                        $variant->product->lang->title,
                                        [
                                            'product/view',
                                            'id' => $variant->product->id,
                                        ],
                                        [ 'target' => '_blank' ]
                                    )
                                ?>
                            </td>
                            <td><?php
                                    if (!empty($item = $basket->getItem($variant->id))) {
                                        echo $item[ 'count' ];
                                    }
                                ?></td>
                            <td><?php echo ( $variant->price ? : 0 ) . ' грн.'; ?></td>
                            <td><?php echo ( ( $variant->price_old - $variant->price ) ? : 0 ) . ' грн.'; ?></td>
                            <td><?php echo $variant->price * $item[ 'count' ] . ' грн.'; ?></td>
                          </tr>
                            <?php
                        }
                    ?>
                </tbody>
                <tfoot>
                  <tr>
                    <th colspan="5"><?php echo \Yii::t('app', 'Total'); ?></th>
                    <th><?php echo $sum; ?> грн.</th>
                  </tr>
                </tfoot>
              </table>
            
            </div>
            <!-- /.table-responsive -->
          </div>
          <!-- /.content -->
          
          <div class="box-footer">
            <div class="pull-left">
                <?php
                    echo Html::a(
                        Html::icon(
                            'chevron-left',
                            [
                                'prefix' => 'fa fa-',
                            ]
                        ) . \Yii::t('app', 'Back to payment method'),
                        [
                            'checkout/payment',
                        ],
                        [
                            'class' => 'btn btn-default',
                        ]
                    )
                ?>
            </div>
            <div class="pull-right">
                <?php
                    echo Html::submitButton(
                        \Yii::t('app', 'Оформить заказ'),
                        [
                            'class' => 'btn btn-success',
                        ]
                    );
                ?>
            </div>
          </div>
            <?php
                $form::end();
            ?>
        </div>
        <!-- /.box -->
      
      
      </div>
      <!-- /.col-md-9 -->
      
      <div class="col-md-3">
        <div class="box" id="order-summary">
          <div class="box-header">
            <h3><?php echo \Yii::t('app', 'Итоговый счет'); ?></h3>
          </div>
          <p class="text-muted small"><?php echo \Yii::t(
                  'app',
                  'Стоимость доставки рассчитывается в зависимости от адреса и способа доставки'
              ); ?></p>
          
          <div class="table-responsive">
            <table class="table">
              <tbody>
                <tr>
                  <td><?php echo \Yii::t('app', 'Всего за товары'); ?></td>
                  <th><?php echo $sum; ?> грн.</th>
                </tr>
                <tr>
                  <td><?php echo \Yii::t('app', 'Сумма скидки'); ?></td>
                  <th><?php echo $sumDiscount; ?> грн.</th>
                </tr>
                <tr>
                  <td><?php echo \Yii::t('app', 'Стоимость доставки'); ?></td>
                  <th><?php echo $model->delivery->value; ?> грн.</th>
                </tr>
                <tr class="total">
                  <td><?php echo \Yii::t('app', 'Итого к оплате'); ?></td>
                  <th><?php echo $sum + $model->delivery->value; ?> грн.</th>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
      <!-- /.col-md-3 -->
    </div>
    <!-- /.row -->
  
  </div>
  <!-- /.container -->
</div>
