<?php
    use artbox\catalog\helpers\FilterHelper;
    use artbox\catalog\models\Brand;
    use artbox\catalog\models\Category;
    use artbox\catalog\models\Product;
    use artbox\core\components\SeoComponent;
    use yii\bootstrap\Html;
    use yii\data\ActiveDataProvider;
    use yii\web\View;
    use yii\widgets\LinkPager;
    use yii\widgets\ListView;
    
    /**
     * @var View               $this
     * @var Category           $model
     * @var SeoComponent       $seo
     * @var FilterHelper       $filterHelper
     * @var ActiveDataProvider $dataProvider
     * @var string             $priceMin
     * @var string             $priceMax
     */
    $seo = \Yii::$app->get('seo');
    $filterHelper = \Yii::$app->get('filter');
    $view = $this;
    $this->params[ 'breadcrumbs' ][] = $seo->title;
?>
<div id="content">
  <div class="container">
    
    <div class="row">
      
      
      <!-- *** LEFT COLUMN ***
_________________________________________________________ -->
      
      <div class="col-sm-3">
        
        <!-- *** MENUS AND FILTERS ***
_________________________________________________________ -->
        
        <div class="panel panel-default sidebar-menu">
            <?php
                if (!empty($model->parent_id) || !empty($model->categories)) {
                    ?>
                  <div class="panel-body">
                    <ul class="nav nav-pills nav-stacked category-menu">
                      <li>
                          <?php
                              if (!empty($model->parent_id)) {
                                  echo Html::a(
                                      $model->parent->lang->title,
                                      [
                                          'view',
                                          'category' => $model->parent->lang->alias->value,
                                      ]
                                  );
                              } else {
                                  echo Html::a($model->lang->title, '#');
                              }
                          ?>
                        <ul>
                            <?php
                                if (!empty($model->parent_id)) {
                                    foreach ($model->parent->categories as $childCategory) {
                                        echo Html::tag(
                                            'li',
                                            Html::a(
                                                $childCategory->lang->title,
                                                ( $childCategory->id === $model->id ) ? '#' : [
                                                    'view',
                                                    'category' => $childCategory->lang->alias->value,
                                                ]
                                            ),
                                            [
                                                'class' => ( $childCategory->id === $model->id ) ? 'active' : '',
                                            ]
                                        );
                                    }
                                } else {
                                    foreach ($model->categories as $childCategory) {
                                        echo Html::tag(
                                            'li',
                                            Html::a(
                                                $childCategory->lang->title,
                                                [
                                                    'view',
                                                    'category' => $childCategory->lang->alias->value,
                                                ]
                                            )
                                        );
                                    }
                                }
                            ?>
                        </ul>
                      </li>
                    </ul>
                  </div>
                    <?php
                }
            ?>
    
            <?php
                if (!empty($filterHelper->getFilter())) {
                    echo Html::a(
                        Html::icon(
                            'times-circle',
                            [
                                'prefix' => 'fa fa-',
                            ]
                        ) . Html::tag(
                            'span',
                            \Yii::t('app', 'Сбросить фильтр'),
                            [
                                'class' => 'hidden-sm',
                            ]
                        ),
                        [
                            'view',
                            'category' => $model->lang->alias->value,
                        ],
                        [
                            'class' => 'btn btn-xs btn-danger reset-filters',
                        ]
                    );
                }
            ?>
            <?php
                $brands = $filterHelper->getBrands($model);
                if (!empty($brands)) {
                    ?>
                  <div class="panel-heading">
                    <h3 class="panel-title"><?php echo \Yii::t('app', 'Бренды'); ?></h3>
                  </div>
                  
                  <div class="panel-body">
                    <div class="form-group">
                        <?php
                            $buthiddenmore = Html::tag(
                                'div',
                                Html::a(
                                    'Ещё',
                                    '#',
                                    [
                                        'class' => 'btn btn-primary btn-xs',
                                    ]
                                ),
                                [
                                    'class' => 'hiddens-button',
                                ]
                            );
                            foreach ($brands as $brand) {
                                /**
                                 * @var Product $product
                                 * @var Brand   $brand
                                 */
                                echo Html::tag(
                                    'div',
                                    Html::a(
                                        $brand->lang->title,
                                        [
                                            '/category/view',
                                            'category' => $model->lang->alias->value,
                                            'filter'   => $filterHelper->buildLink($brand),
                                        ]
                                    ),
                                    [
                                        'class' => $filterHelper->has(
                                            $brand->lang->alias->value
                                        ) ? 'radio-but checked' : 'radio-but',
                                    ]
                                );
                            }
                        ?>
                    </div>
                  </div>
                    <?php
                }
            ?>
        </div>
          
          <?php
              foreach ($model->productOptionGroupCompls as $group) {
                  ?>
                <div class="panel panel-default sidebar-menu">
                  <div class="panel-heading">
                    <h3><?php echo $group->lang->title; ?></h3>
                  </div>
                  <div class="panel-body">
                    <div class="form-group">
                        <?php
                            $firstsix = 0;
                            $buthiddenmore = Html::tag(
                                'div',
                                Html::a(
                                    'Ещё',
                                    '#',
                                    [
                                        'class' => 'btn btn-primary btn-xs',
                                    ]
                                ),
                                [
                                    'class' => 'hiddens-button',
                                ]
                            );
                            foreach ($group->options as $option) {
                                /**
                                 * @var Product $product
                                 */
                                echo Html::tag(
                                    'div',
                                    Html::a(
                                        $option->lang->value,
                                        [
                                            '/category/view',
                                            'category' => $model->lang->alias->value,
                                            'filter'   => $filterHelper->buildLink($option),
                                        ]
                                    ),
                                    [
                                        'class' => $filterHelper->has(
                                            $option->lang->alias->value
                                        ) ? 'radio-but checked' : 'radio-but',
                                    ]
                                );
                                $firstsix++;
                                if ($firstsix == 6) {
                                    break;
                                }
                            }
                        ?>
                      <div class="hiddens">
                          <?php
                              $nextsix = 0;
                              foreach ($group->options as $option) {
                                  /**
                                   * @var Product $product
                                   */
                                  $nextsix++;
                                  if ($nextsix > 6) {
                                      echo Html::tag(
                                          'div',
                                          Html::a(
                                              $option->lang->value,
                                              [
                                                  '/category/view',
                                                  'category' => $model->lang->alias->value,
                                                  'filter'   => $filterHelper->buildLink($option),
                                              ]
                                          ),
                                          [
                                              'class' => $filterHelper->has(
                                                  $option->lang->alias->value
                                              ) ? 'radio-but checked' : 'radio-but',
                                          ]
                                      );
                                  }
                              }
                              if ($nextsix > 6) {
                                  $morebutton = $buthiddenmore;
                              } else {
                                  $morebutton = '';
                              }
                          ?>
                      </div>
                        <?php echo $morebutton; ?>
                    </div>
                  </div>
                </div>
                  <?php
              }
              foreach ($model->productOptionGroupExcls as $group) {
                  ?>
                <div class="panel panel-default sidebar-menu">
                  <div class="panel-heading">
                    <h3><?php echo $group->lang->title; ?></h3>
                  </div>
                  <div class="panel-body">
                    <div class="form-group">
                        <?php
                            $firstsix = 0;
                            $buthiddenmore = Html::tag(
                                'div',
                                Html::a(
                                    'Ещё',
                                    '#',
                                    [
                                        'class' => 'btn btn-primary btn-xs',
                                    ]
                                ),
                                [
                                    'class' => 'hiddens-button',
                                ]
                            );
                            foreach ($group->options as $option) {
                                /**
                                 * @var Product $product
                                 */
                                echo Html::tag(
                                    'div',
                                    Html::a(
                                        $option->lang->value,
                                        [
                                            '/category/view',
                                            'category' => $model->lang->alias->value,
                                            'filter'   => $filterHelper->buildLink($option),
                                        ]
                                    ),
                                    [
                                        'class' => $filterHelper->has(
                                            $option->lang->alias->value
                                        ) ? 'radio-but checked' : 'radio-but',
                                    ]
                                );
                                $firstsix++;
                                if ($firstsix == 6) {
                                    break;
                                }
                            }
                        ?>
                      <div class="hiddens">
                          <?php
                              $nextsix = 0;
                              foreach ($group->options as $option) {
                                  /**
                                   * @var Product $product
                                   */
                                  $nextsix++;
                                  if ($nextsix > 6) {
                                      echo Html::tag(
                                          'div',
                                          Html::a(
                                              $option->lang->value,
                                              [
                                                  '/category/view',
                                                  'category' => $model->lang->alias->value,
                                                  'filter'   => $filterHelper->buildLink($option),
                                              ]
                                          ),
                                          [
                                              'class' => $filterHelper->has(
                                                  $option->lang->alias->value
                                              ) ? 'radio-but checked' : 'radio-but',
                                          ]
                                      );
                                  }
                              }
                              if ($nextsix > 6) {
                                  $morebutton = $buthiddenmore;
                              } else {
                                  $morebutton = '';
                              }
                          ?>
                      </div>
                        <?php echo $morebutton; ?>
                    </div>
                  </div>
                </div>
                  <?php
              }
              foreach ($model->variantOptionGroupCompls as $group) {
                  ?>
                <div class="panel panel-default sidebar-menu">
                  <div class="panel-heading">
                    <h3><?php echo $group->lang->title; ?></h3>
                  </div>
                  <div class="panel-body">
                    <div class="form-group">
                        <?php
                            $firstsix = 0;
                            $buthiddenmore = Html::tag(
                                'div',
                                Html::a(
                                    'Ещё',
                                    '#',
                                    [
                                        'class' => 'btn btn-primary btn-xs',
                                    ]
                                ),
                                [
                                    'class' => 'hiddens-button',
                                ]
                            );
                            foreach ($group->options as $option) {
                                /**
                                 * @var Product $product
                                 */
                                echo Html::tag(
                                    'div',
                                    Html::a(
                                        $option->lang->value,
                                        [
                                            '/category/view',
                                            'category' => $model->lang->alias->value,
                                            'filter'   => $filterHelper->buildLink($option),
                                        ]
                                    ),
                                    [
                                        'class' => $filterHelper->has(
                                            $option->lang->alias->value
                                        ) ? 'radio-but checked' : 'radio-but',
                                    ]
                                );
                                $firstsix++;
                                if ($firstsix == 6) {
                                    break;
                                }
                            }
                        ?>
                      <div class="hiddens">
                          <?php
                              $nextsix = 0;
                              foreach ($group->options as $option) {
                                  /**
                                   * @var Product $product
                                   */
                                  $nextsix++;
                                  if ($nextsix > 6) {
                                      echo Html::tag(
                                          'div',
                                          Html::a(
                                              $option->lang->value,
                                              [
                                                  '/category/view',
                                                  'category' => $model->lang->alias->value,
                                                  'filter'   => $filterHelper->buildLink($option),
                                              ]
                                          ),
                                          [
                                              'class' => $filterHelper->has(
                                                  $option->lang->alias->value
                                              ) ? 'radio-but checked' : 'radio-but',
                                          ]
                                      );
                                  }
                              }
                              if ($nextsix > 6) {
                                  $morebutton = $buthiddenmore;
                              } else {
                                  $morebutton = '';
                              }
                          ?>
                      </div>
                        <?php echo $morebutton; ?>
                    </div>
                  </div>
                </div>
                  <?php
              }
              foreach ($model->variantOptionGroupExcls as $group) {
                  ?>
                <div class="panel panel-default sidebar-menu">
                  <div class="panel-heading">
                    <h3><?php echo $group->lang->title; ?></h3>
                  </div>
                  <div class="panel-body">
                    <div class="form-group">
                        <?php
                            $firstsix = 0;
                            $buthiddenmore = Html::tag(
                                'div',
                                Html::a(
                                    'Ещё',
                                    '#',
                                    [
                                        'class' => 'btn btn-primary btn-xs',
                                    ]
                                ),
                                [
                                    'class' => 'hiddens-button',
                                ]
                            );
                            foreach ($group->options as $option) {
                                /**
                                 * @var Product $product
                                 */
                                echo Html::tag(
                                    'div',
                                    Html::a(
                                        $option->lang->value,
                                        [
                                            '/category/view',
                                            'category' => $model->lang->alias->value,
                                            'filter'   => $filterHelper->buildLink($option),
                                        ]
                                    ),
                                    [
                                        'class' => $filterHelper->has(
                                            $option->lang->alias->value
                                        ) ? 'radio-but checked' : 'radio-but',
                                    ]
                                );
                                $firstsix++;
                                if ($firstsix == 6) {
                                    break;
                                }
                            }
                        ?>
                      <div class="hiddens">
                          <?php
                              $nextsix = 0;
                              foreach ($group->options as $option) {
                                  /**
                                   * @var Product $product
                                   */
                                  $nextsix++;
                                  if ($nextsix > 6) {
                                      echo Html::tag(
                                          'div',
                                          Html::a(
                                              $option->lang->value,
                                              [
                                                  '/category/view',
                                                  'category' => $model->lang->alias->value,
                                                  'filter'   => $filterHelper->buildLink($option),
                                              ]
                                          ),
                                          [
                                              'class' => $filterHelper->has(
                                                  $option->lang->alias->value
                                              ) ? 'radio-but checked' : 'radio-but',
                                          ]
                                      );
                                  }
                              }
                              if ($nextsix > 6) {
                                  $morebutton = $buthiddenmore;
                              } else {
                                  $morebutton = '';
                              }
                          ?>
                      </div>
                        <?php echo $morebutton; ?>
                    </div>
                  </div>
                </div>
                  <?php
              }
          ?>
        <!-- *** MENUS AND FILTERS END *** -->
        
        <!-- /.banner -->
        <div class="panel-heading">
          <h3 class="panel-title"><?php echo \Yii::t('app', 'Цена'); ?></h3>
        </div>
        <div class="panel-body">
          <div class="form-group">
            <div style="width:200px;">
              <div class="price_filter first_price_li">
                <div class="price_slider">
                    <?php
                        $filters = $filterHelper->getGroupFilters();
                        if (isset($filters[ 'prices' ])) {
                            $currentMin = $filters[ 'prices' ][ 0 ];
                            $currentMax = $filters[ 'prices' ][ 1 ];
                        } else {
                            $currentMin = $priceMin;
                            $currentMax = $priceMax;
                        }
                        echo Html::textInput(
                            'price_interval',
                            '',
                            [
                                'id'   => 'price_interval',
                                'data' => [
                                    'pricemin'   => $priceMin,
                                    'pricemax'   => $priceMax,
                                    'currentMin' => $currentMin,
                                    'currentMax' => $currentMax,
                                ],
                            ]
                        );
                    ?>
                </div>
              </div>
            </div>
            <div class="price-inputs col-md-12">
              <div class="col-md-4 input-block">
                <input type="text" name="price-min" id="price-min">
              </div>
              <div class="col-md-1 input-sep"> -</div>
              <div class="col-md-4 input-block">
                <input type="text" name="price-max" id="price-max">
              </div>
            </div>
            <div class="col-md-12 row">
              <button class="price-apply btn btn-primary">применить</button>
            </div>

          </div>
        </div>
      </div>
      <!-- /.col-md-3 -->
      
      <!-- *** LEFT COLUMN END *** -->
      
      <!-- *** RIGHT COLUMN ***
_________________________________________________________ -->
      
      <div class="col-sm-9">
        <div class="col-md-12 sort-cat-wr">
          <p><?php echo \Yii::t('app', 'Сортировка'); ?>:</p>
          <div class="sort-cat">
              <?php
                  $currentSortAttribute = array_keys($dataProvider->sort->attributes)[ 0 ];
                  $currentSort = \Yii::$app->request->get($dataProvider->sort->sortParam);
                  if (!empty($currentSort)) {
                      if (preg_match('/^-?(\w+)$/', $currentSort, $matches)) {
                          if (array_key_exists($matches[ 1 ], $dataProvider->sort->attributes)) {
                              $currentSortAttribute = $matches[ 1 ];
                          }
                      }
                  }
                  echo $dataProvider->sort->link(
                      $currentSortAttribute,
                      [
                          'label' => Html::tag(
                                  'span',
                                  $dataProvider->sort->attributes[ $currentSortAttribute ][ 'label' ]
                              ) . Html::tag(
                                  'i',
                                  '',
                                  [
                                      'class'       => 'fa fa-angle-down',
                                      'aria-hidden' => true,
                                  ]
                              ),
                      ]
                  );
              ?>
            <ul class="sorter">
                <?php
                    foreach ($dataProvider->sort->attributes as $attribute => $sort) {
                        if ($currentSortAttribute == $attribute) {
                            continue;
                        }
                        echo Html::tag('li', $dataProvider->sort->link($attribute));
                    }
                ?>
            </ul>
          </div>
        </div>
          <?php
              echo ListView::widget(
                  [
                      'options'      => [
                          'class' => 'row products',
                      ],
                      'itemOptions'  => [
                          'tag' => false,
                      ],
                      'layout'       => '{items}',
                      'dataProvider' => $dataProvider,
                      'itemView'     => function ($model) use ($view) {
                          /**
                           * @var Product $model
                           */
                          return $view->render(
                              '_product_item',
                              [
                                  'product' => $model,
                              ]
                          );
                      },
                  ]
              );
              echo Html::tag(
                  'div',
                  LinkPager::widget(
                      [
                          'pagination' => $dataProvider->pagination,
                      ]
                  ),
                  [
                      'class' => 'pages',
                  ]
              );
          ?>
      
      </div>
      <!-- /.col-md-9 -->
      
      <!-- *** RIGHT COLUMN END *** -->
    
    </div>
  
  </div>
  <!-- /.container -->
</div>
<!-- /#content -->