<?php
    
    use artbox\webcomment\widgets\CommentWidget;
    use artbox\weblog\models\Article;
    use artbox\weblog\models\Tag;
    use frontend\widgets\BlogSearch;
    use yii\helpers\Url;
    use yii\web\View;
    
    /**
     * @var View    $this
     * @var Article $model
     * @var Tag[]   $tags
     */
    
    $this->params[ 'breadcrumbs' ][] = [
        'label' => \Yii::t('app', 'Блог'),
        'url'   => [ 'blog/index' ],
    ];
    
    $this->params[ 'breadcrumbs' ][] = $model->lang->title;

?>

<div id="content">
  <div class="container">
    
    <div class="row">
      
      <!-- *** LEFT COLUMN ***
_________________________________________________________ -->
      
      <div class="col-md-9" id="blog-post">
        
        <h2><?= $model->lang->title; ?></h2>
          
          <?php if (!empty($model->tags)) { ?>
            <div class="panel sidebar-menu">
              <div class="panel-body">
                <ul class="tag-cloud">
                    <?php foreach ($model->tags as $tag) { ?>
                      <li><a href="<?= Url::to(
                              [
                                  'blog/tag',
                                  'id' => $tag->id,
                              ]
                          ) ?>"><i class="fa fa-tags"></i>&#160<?= $tag->lang->label; ?></a>
                      </li>
                    <?php } ?>
                </ul>
              </div>
            </div>
          <?php } ?>
        
        <p class="text-muted text-uppercase mb-small text-left"><?= \Yii::$app->formatter->asDate(
                $model->created_at
            ); ?></p>
        
        <div id="post-content">
            
            <?= $model->lang->body; ?>

        </div>
        <!-- /#post-content -->
          
          <?php
              /*
  
                <div id="comments">
                    <h4 class="text-uppercase">2 comments</h4>
                    
                    
                    <div class="row comment">
                        <div class="col-sm-3 col-md-2 text-center-xs">
                            <p>
                                <img src="img/blog-avatar2.jpg" class="img-responsive img-circle" alt="">
                            </p>
                        </div>
                        <div class="col-sm-9 col-md-10">
                            <h5 class="text-uppercase">Julie Alma</h5>
                            <p class="posted"><i class="fa fa-clock-o"></i> September 23, 2011 в 12:00</p>
                            <p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper.
                                Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>
                            <p class="reply"><a href="#"><i class="fa fa-reply"></i> Ответить</a>
                            </p>
                        </div>
                    </div>
                    <!-- /.comment -->
                    
                    
                    <div class="row comment last">
                        
                        <div class="col-sm-3 col-md-2 text-center-xs">
                            <p>
                                <img src="img/blog-avatar.jpg" class="img-responsive img-circle" alt="">
                            </p>
                        </div>
                        
                        <div class="col-sm-9 col-md-10">
                            <h5 class="text-uppercase">Louise Armero</h5>
                            <p class="posted"><i class="fa fa-clock-o"></i> 23 сентября 2012 в 12:00</p>
                            <p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper.
                                Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>
                            <p class="reply"><a href="#"><i class="fa fa-reply"></i> Ответить</a>
                            </p>
                        </div>
                    
                    </div>
                    <!-- /.comment -->
                </div>
                <!-- /#comments -->
                
                
                <div id="comment-form">
                    
                    <h4 class="text-uppercase">Leave comment</h4>
                    
                    <form>
                        <div class="row">
                            
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="name">Name <span class="required">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="name">
                                </div>
                            </div>
                        
                        </div>
                        
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="email">Email <span class="required">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="email">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label for="comment">Comment <span class="required">*</span>
                                    </label>
                                    <textarea class="form-control" id="comment" rows="4"></textarea>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-sm-12 text-right">
                                <button class="btn btn-template-main"><i class="fa fa-comment-o"></i> Post comment</button>
                            </div>
                        </div>
                    
                    
                    </form>
                
                </div>
                <!-- /#comment-form -->
            */
          ?>
          <?php
              echo CommentWidget::widget(
                  [
                      'model' => $model,
                  ]
              );
          ?>
      </div>
      <!-- /#blog-post -->
      
      <!-- *** LEFT COLUMN END *** -->
  
      <!-- *** RIGHT COLUMN ***
  _________________________________________________________ -->
      
      <div class="col-md-3">
        
        <!-- *** MENUS AND WIDGETS ***
_________________________________________________________ -->
        <div class="panel panel-default sidebar-menu">
          
          <div class="panel-heading">
            <h3 class="panel-title">Блог компании</h3>
          </div>
          
          <div class="panel-body text-widget">
            <p>
              Мы собираем полезные материалы по тематике бытовой техники и электроники
            </p>
          
          </div>
        </div>
    
          <?= BlogSearch::widget(); ?>
        
        <div class="panel sidebar-menu">
          <div class="panel-heading">
            <h3 class="panel-title">Поиск по тегам</h3>
          </div>
          
          <div class="panel-body">
            <ul class="tag-cloud">
                <?php foreach ($tags as $tag) { ?>
                  <li><a href="<?= Url::to(
                          [
                              'blog/tag',
                              'id' => $tag->id,
                          ]
                      ) ?>"><i class="fa fa-tags"></i>&#160<?= $tag->lang->label; ?></a>
                  </li>
                <?php } ?>
            </ul>
          </div>
        </div>
        
        <!-- *** MENUS AND FILTERS END *** -->
      
      </div>
      <!-- /.col-md-3 -->
      <!-- *** RIGHT COLUMN END *** -->
    
    
    </div>
    <!-- /.row -->
  
  </div>
  <!-- /.container -->
</div>
<!-- /#content -->
  