<?php
    
    use artbox\core\components\SeoComponent;
    use artbox\weblog\models\Category;
    use artbox\weblog\models\Tag;
    use frontend\widgets\BlogSearch;
    use yii\data\ActiveDataProvider;
    use yii\helpers\Url;
    use yii\web\View;
    use yii\widgets\ListView;
    
    /**
     * @var View               $this
     * @var ActiveDataProvider $dataProvider
     * @var SeoComponent       $seo
     * @var Tag[]              $tags
     * @var Category           $model
     */
    $seo = \Yii::$app->get('seo');
    
    $this->params[ 'breadcrumbs' ][] = [
        'label' => \Yii::t('app', 'Блог'),
        'url'   => [ 'blog/index' ],
    ];
    
    $this->params[ 'breadcrumbs' ][] = $seo->title;

?>

<div id="content">
  <div class="container">
    <div class="row">
      <!-- *** LEFT COLUMN ***
_________________________________________________________ -->
      
      
      <!--        <ul class="pager">-->
      <!--          <li class="previous"><a href="#">&larr; Назад</a>-->
      <!--          </li>-->
      <!--          <li class="next disabled"><a href="#">Вперед &rarr;</a>-->
      <!--          </li>-->
      <!--        </ul>-->
      
      <!-- /.col-md-9 -->
        
        
        <?= ListView::widget(
            [
                'dataProvider' => $dataProvider,
                'itemView'     => '_article',
                'options'      => [
                    'class' => 'col-md-9',
                    'id'    => 'blog-listing-medium',
                ],
                'layout'       => '{items}{pager}',
            ]
        ); ?>
      
      
      <!-- *** LEFT COLUMN END *** -->
      
      <!-- *** RIGHT COLUMN ***
_________________________________________________________ -->
      
      <div class="col-md-3">
        
        <!-- *** MENUS AND WIDGETS ***
_________________________________________________________ -->
        <div class="panel panel-default sidebar-menu">
          
          <div class="panel-heading">
            <h3 class="panel-title">Блог компании</h3>
          </div>
          
          <div class="panel-body text-widget">
            <p>
              Мы собираем полезные материалы по тематике бытовой техники и электроники
            </p>
          
          </div>
        </div>
    
          <?= BlogSearch::widget(); ?>
        
        <div class="panel sidebar-menu">
          <div class="panel-heading">
            <h3 class="panel-title">Поиск по тегам</h3>
          </div>
          
          <div class="panel-body">
            <ul class="tag-cloud">
                <?php foreach ($tags as $tag) { ?>
                  <li><a href="<?= Url::to(
                          [
                              'blog/tag',
                              'id' => $tag->id,
                          ]
                      ) ?>"><i class="fa fa-tags"></i>&#160<?= $tag->lang->label; ?></a>
                  </li>
                <?php } ?>
            </ul>
          </div>
        </div>
        
        <!-- *** MENUS AND FILTERS END *** -->
      
      </div>
      <!-- /.col-md-3 -->
      
      <!-- *** RIGHT COLUMN END *** -->
    
    </div>
    <!-- /.row -->
  </div>
  <!-- /.container -->
</div>
<!-- /#content -->