<?php
    
    use artbox\core\helpers\ImageHelper;
    use artbox\weblog\models\Article;
    use yii\bootstrap\Html;
    use yii\helpers\Url;
    
    /**
     * @var Article $model
     */

?>

<section class="post">
  <div class="row">
    <div class="col-md-4">
      <div class="image">
        <a href="<?= Url::to(
            [
                'blog/article',
                'id' => $model->id,
            ]
        ) ?>">
            <?= ImageHelper::set($model->image ? $model->image->getPath() : '@frontend/web/img/no-image.png')
                           ->cropResize(263, 197)
                           ->renderImage(
                               [
                                   'class' => 'img-responsive',
                                   'alt'   => $model->lang->title,
                               ]
                           ) ?>
        </a>
      </div>
    </div>
    <div class="col-md-8">
      <h2><a href="<?= Url::to(
              [
                  'blog/article',
                  'id' => $model->id,
              ]
          ) ?>"><?= $model->lang->title; ?></a></h2>
      <div class="clearfix">
          <?php if (empty($model->categories)) { ?>
            <p class="author-category">Без категории </p>
          <?php } else {
              $i = 0;
              foreach ($model->categories as $category) {
                  $i++;
                  ?>
                <p class="author-category"><?php
                        echo Html::a(
                            $category->lang->title,
                            [
                                'blog/category',
                                'id' => $category->id,
                            ]
                        );
                        if ($i === count($model->categories)) {
                            echo '&#160';
                        } else {
                            echo '&#44&#160';
                        }
                    ?></p>
                  <?php
              }
          } ?>
        <p class="date-comments">
          <i class="fa fa-calendar-o"></i> <?= \Yii::$app->formatter->asDate($model->created_at); ?>
          <!--          <a href="blog-post.html"><i class="fa fa-comment-o"></i> 8 комментариев</a>-->
        </p>
      </div>
      <p class="intro"><?= $model->lang->body_preview; ?></p>
      <p class="read-more">
          <?= Html::a(
              'Продолжить чтение',
              [
                  'blog/article',
                  'id' => $model->id,
              ],
              [
                  'class' => 'btn btn-template-main',
              ]
          ) ?>
      </p>
    </div>
  </div>
</section>
