<?php
    
    use yii\data\ActiveDataProvider;
    use yii\web\View;
    use yii\widgets\ListView;
    use yii\widgets\Pjax;
    
    /**
     * @var View               $this
     * @var ActiveDataProvider $dataProvider
     */
    
    $this->params[ 'breadcrumbs' ][] = \Yii::t('app', 'Мои пожелания');
?>

<div id="content">
  <div class="container">
    
    <div class="row">
      
      <!-- *** LEFT COLUMN ***
_________________________________________________________ -->
      
      <div class="col-md-9 clearfix">
        
        <div class="row products">
            <?php
                Pjax::begin(
                    [
                        'id' => 'wishlist-products',
                    ]
                );
                echo ListView::widget(
                    [
                        'dataProvider' => $dataProvider,
                        'itemView'     => '_product',
                        'layout'       => '{items}{pager}',
                    ]
                );
                Pjax::end();
            ?>
          
          <!-- /.col-md-4 -->
        </div>
        <!-- /.products -->
      
      </div>
      <!-- /.col-md-9 -->
      
      <!-- *** LEFT COLUMN END *** -->
      
      <!-- *** RIGHT COLUMN ***
_________________________________________________________ -->
      
      <div class="col-md-3">
        <!-- *** CUSTOMER MENU ***
_________________________________________________________ -->
          <?= $this->render('_menu') ?>
        <!-- /.col-md-3 -->
        
        <!-- *** CUSTOMER MENU END *** -->
      </div>
      
      <!-- *** RIGHT COLUMN END *** -->
    
    </div>
    <!-- /.row -->
  
  </div>
  <!-- /.container -->
</div>
<!-- /#content -->
        